<?php


use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\base\Tercero;
use backend\models\base\Grupo;

$this->title = 'Carga Académica';
$this->params['breadcrumbs'][] = ['label' => 'Carga Académica', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Ver';

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'PDF', 'url' => 'pdf', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];

?>

<div class="academico-view">

    <div class="row">
<?php 
    /*
    if ($model->tipo_tercero==1) $color="success";
    if ($model->tipo_tercero==2) $color="info";
    if ($model->tipo_tercero==3) $color="warning";
    if ($model->tipo_tercero==4) $color="danger";
*/
    $gridColumn = [
        [
            'columns' => [
                [
                    'attribute'=>'estudiante',
                    'value'=>$model->estudiantes->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Tercero::find()->asArray()->all(), 'id', 'primer_apellido'),
                    ],
                ],
                [
                    'attribute'=>'grupo',
                    'value'=>$model->grupos->grupo,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Grupo::find()->asArray()->all(), 'id', 'grupo'),
                    ],
                ],
                
            ],
        ], 

        [    
            'columns' => [
                [
                    'attribute'=>'fecha_matricula', 
                    'format'=>'date',
                    'type'=>DetailView::INPUT_DATE,
                    'widgetOptions' => [
                        'pluginOptions'=>['autoclose' => true,
                                          'format' => 'yyyy-mm-dd',
                                          'todayHighlight' => true]
                    ],
                    'valueColOptions'=>['style'=>'width:30%'],
                ],  
                [
                    'attribute'=>'fecha_retiro', 
                    'format'=>'date',
                    'type'=>DetailView::INPUT_DATE,
                    'widgetOptions' => [
                        'pluginOptions'=>['autoclose' => true,
                                          'format' => 'yyyy-mm-dd',
                                          'todayHighlight' => true]
                    ],
                    'valueColOptions'=>['style'=>'width:30%'],
                ],           
                
            ],
        ],
           
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_DEFAULT,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);

echo "<center>";
echo Html::a('<i class="far fa-file-pdf fa-lg"></i> Hoja de Vida', ['tercero/hojadevida', 'id' => $model->estudiante], ['class' => 'btn btn-md btn-danger', 'data-toggle' => 'tooltip', 'title' => 'Exportar Hoja de Vida', 'target' => "_blank"])." ";
echo Html::a('<i class="far fa-pencil fa-lg"></i> Editar Tercero', ['tercero/update', 'id' => $model->estudiante], ['class' => 'btn btn-md btn-success', 'data-toggle' => 'tooltip', 'title' => 'Editar Tercero'])." ";
echo Html::a('<i class="far fa-plus fa-lg"></i> Nuevo Tercero', ['tercero/create'], ['class' => 'btn btn-md btn-primary', 'data-toggle' => 'tooltip', 'title' => 'Crear Nuevo Tercero']);
echo "</center>";
?>
    </div>


</div>