<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use backend\models\Tercero;
use backend\models\Tipodocumento;
use backend\models\Rh;
use backend\models\Genero;
use backend\models\Parentesco;

use yii\db\Expression;
use kartik\widgets\Select2;

$idf = Yii::$app->controller->id==='estudiante' ? '-acudiente' : '';
?>


     <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario'.$idf,
                    ]
    ]); ?>
    
<div class="row">

    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
</div>    
<div class="row">
    <div class="col-sm-6">
        <?
            if (Yii::$app->controller->id=='estudiante')
            {   
                $estudiante = $tercero;
            }
            else
            {
                $estudiante = Yii::$app->request->get('id');
            }    

            if ($estudiante)
            {
                $data = ArrayHelper::map(Tercero::find()->select(['id', new Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['tipo_tercero' => '1', 'id' => $estudiante])->andWhere(['<', 'estado', '3'])->orderBy('id')->asArray()->all(), 'id', 'nombre');
                $model->estudiante = $estudiante;
            } 
            else 
            {
                $query = 'SELECT id, CONCAT(primer_nombre," ", segundo_nombre, " ", primer_apellido, " ", segundo_apellido) as nombre FROM tercero WHERE tercero.tipo_tercero =1 and tercero.estado <3';
                $data = ArrayHelper::map(Tercero::findBySql($query)->asArray()->all(), 'id', 'nombre');
            }   

            
        ?>

        <?= $form->field($model, 'estudiante')->widget(Select2::classname(), [
            'data' => $data,
            'options' => ['placeholder' => 'Seleccione Estudiante'],
            'pluginOptions' => [
            ],
        ]) ?>
    </div>       
    <div class="col-sm-3">
        <?= $form->field($model, 'tipo')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Tipodocumento::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
            'options' => ['placeholder' => 'Seleccione el Tipo de Documento'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    </div>
    <div class="col-sm-3">
        <?= $form->field($model, 'identificacion')->textInput(['maxlength' => true, 'placeholder' => 'Número de Identificación']) ?>
    </div>       
</div>    
<div class="row">    
    <div class="col-sm-3">
        <?= $form->field($model, 'primer_nombre')->textInput(['maxlength' => true, 'placeholder' => 'Primer Nombre']) ?>
    </div>       
    
    <div class="col-sm-3">
        <?= $form->field($model, 'segundo_nombre')->textInput(['maxlength' => true, 'placeholder' => 'Segundo Nombre']) ?>
    </div>       
    
    <div class="col-sm-3">
        <?= $form->field($model, 'primer_apellido')->textInput(['maxlength' => true, 'placeholder' => 'Primer Apellido']) ?>
    </div>       
    
    <div class="col-sm-3">
        <?= $form->field($model, 'segundo_apellido')->textInput(['maxlength' => true, 'placeholder' => 'Segundo Apellido']) ?>
    </div>       
</div>    
<div class="row">    
    <div class="col-sm-3">
        <?= $form->field($model, 'genero')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Genero::find()->orderBy('id')->asArray()->all(), 'id', 'genero'),
            'options' => ['placeholder' => 'Seleccione el Género'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    </div>       
    
    <div class="col-sm-3">
        <?= $form->field($model, 'parentesco')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Parentesco::find()->orderBy('id')->asArray()->all(), 'id', 'parentesco'),
            'options' => ['placeholder' => 'Seleccione el Parentesco'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    </div>       
    
    <div class="col-sm-3">
        <?= $form->field($model, 'rh')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Rh::find()->orderBy('id')->asArray()->all(), 'id', 'rh'),
            'options' => ['placeholder' => 'Seleccione el Grupo Sanguineo y RH'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    </div>       
    
    <div class="col-sm-3">
        <?= $form->field($model, 'direccion')->textInput(['maxlength' => true, 'placeholder' => 'Dirección']) ?>
    </div>       
</div>    
<div class="row">    
    <div class="col-sm-3">
        <?= $form->field($model, 'fijo')->textInput(['maxlength' => true, 'placeholder' => 'Fijo']) ?>
    </div>       
    
    <div class="col-sm-3">
        <?= $form->field($model, 'movil')->textInput(['maxlength' => true, 'placeholder' => 'Móvil']) ?>
    </div>       
    
    <div class="col-sm-6">
        <?= $form->field($model, 'email')->textInput(['maxlength' => true, 'placeholder' => 'Email']) ?>
    </div>       
</div>    
<div class="row">    
    <div class="col-sm-12">

        <div class="form-group">
            <?= Html::submitButton($model->isNewRecord ? 'Crear' : 'Actualizar', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        </div>
    </div>       
</div>        
<?php ActiveForm::end(); ?>
