<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\DepDrop;
use yii\db\Expression;

use backend\models\Tercero;
use backend\models\Tipodocumento;
use backend\models\Rh;
use backend\models\Genero;
use backend\models\Parentesco;




$this->registerJs("

$(document).ready(function() {
    
    $('#aplicar').click(function() {
        
        //$('#aplicar').prop('disabled', true);
        id = $('#acudiente-estudiante').val();
        //tipo = $('#acudiente-tipo option:selected').text();

        id = $('#acudiente-id').val();
        estudiante = $('#acudiente-estudiante').val();
        tipo = $('#acudiente-tipo').val();
        identificacion = $('#acudiente-identificacion').val();
        primer_nombre = $('#acudiente-primer_nombre').val();
        segundo_nombre = $('#acudiente-segundo_nombre').val();
        primer_apellido = $('#acudiente-primer_apellido').val();
        segundo_apellido = $('#acudiente-segundo_apellido').val();
        genero = $('#acudiente-genero').val();
        parentesco = $('#acudiente-parentesco').val();
        rh = $('#acudiente-rh').val();
        direccion = $('#acudiente-direccion').val();
        fijo = $('#acudiente-fijo').val();
        movil = $('#acudiente-movil').val();
        email = $('#acudiente-email').val();
        
            
        if(!tipo)
        {
            $('.field-acudiente-tipo > .help-block-error').html('<span style=\"color: #a94442\">Tipo de Documento no puede estar vacío.</span>');   
        }

        if(!identificacion)
        {
            $('.field-acudiente-identificacion > .help-block-error').html('<span style=\"color: #a94442\">Número de Identificación no puede estar vacío.</span>');   
        }

        if(!primer_nombre)
        {
            $('.field-acudiente-primer_nombre > .help-block-error').html('<span style=\"color: #a94442\">Primer Nombre no puede estar vacío.</span>');   
        }

        if(!primer_apellido)
        {
            $('.field-acudiente-primer_apellido > .help-block-error').html('<span style=\"color: #a94442\">Primer Apellido no puede estar vacío.</span>');   
        }

        if(!genero)
        {
            $('.field-acudiente-genero > .help-block-error').html('<span style=\"color: #a94442\">Género no puede estar vacío.</span>');   
        }

        if(!parentesco)
        {
            $('.field-acudiente-parentesco > .help-block-error').html('<span style=\"color: #a94442\">Parentesco no puede estar vacío.</span>');   
        }

        if(!rh)
        {
            $('.field-acudiente-rh > .help-block-error').html('<span style=\"color: #a94442\">Grupo Sanguineo y Factor RH no puede estar vacío.</span>');   
        }

        if(!movil)
        {
            $('.field-acudiente-movil > .help-block-error').html('<span style=\"color: #a94442\">Teléfono Celular no puede estar vacío.</span>');   
        }

        if(!email)
        {
            $('.field-acudiente-email > .help-block-error').html('<span style=\"color: #a94442\">Correo Electrónico no puede estar vacío.</span>');   
        }

        $.ajax({
            type: 'POST',
            url: '". Url::to(['save'])."',
            timeout: 1000,

            data: {id : id, estudiante : estudiante, tipo : tipo, identificacion : identificacion, primer_nombre : primer_nombre, segundo_nombre : segundo_nombre, primer_apellido: primer_apellido, segundo_apellido: segundo_apellido, genero : genero, parentesco : parentesco, rh :rh, direccion : direccion, fijo : fijo, movil : movil, email : email },

            success: function (data) {
                
                if(data != '')
                {
                    //$('#list-tab').append('<a class=\"list-group-item list-group-item-action\" id=\"' + data + '\" data-toggle=\"list\" href=\"#list-' + data + '\" role=\"tab\" aria-controls=\"list-' + data + '\">' + nivel + '<button type=\"button\" id=\"addbutton\" class=\"showModalButton btn btn-xs btn-warning\" value=\"/sonic/admin/frd/add?competencia=' + competencia + '&amp;nivel=' + data + '\" title=\"Agregar FRD\" style=\"float:right;\"><i id=\"showCreateFRD\" class=\"fa fa-plus\" aria-hidden=\"true\"></i> Agregar FRD</button></a>');
                    
                    //$('#list-tab').append('<a class=\"list-group-item list-group-item-action\" id=\"nivel-' + data + '\" data-toggle=\"list\" href=\"#list-' + data + '\" role=\"tab\" aria-controls=\"list-' + data + '\" aria-selected=\"false\">' + primer_nombre + '<div class=\"btn-group\" style=\"float:right; padding-left: 10px;\"><button type=\"button\" class=\"btn btn-xs btn-danger btn-xs\" value=\"../nivel/delete?id=' + data + '\" title=\"\" data-toggle=\"tooltip\" style=\"float:right;\" onclick=\"eliminar_nivel(' + data + ')\" data-original-title=\"Eliminar\"><i id=\"trash\" class=\"fa fa-trash-alt\" aria-hidden=\"true\"></i></button><button type=\"button\" class=\"showModalButton btn btn-xs btn-success btn-xs\" value=\"../nivel/update?id=' + data + '\" title=\"\" data-toggle=\"tooltip\" style=\"float:right;\" data-original-title=\"Editar\"><i id=\"edit\" class=\"fa fa-pencil\" aria-hidden=\"true\"></i></button><button type=\"button\" id=\"addbutton\" class=\"showModalButton btn btn-xs btn-primary\" value=\"../frd/add?competencia=' + id + '&amp;nivel=' + data + '\" title=\"Agregar FRD\"><i id=\"showCreateFRD\" class=\"fa fa-plus\" aria-hidden=\"true\"></i> FRD</button></div><span class=\"badge badge-pill\" style=\"color:#fff; background-color:#ccc' + data + ';\">'+ parentesco +'</span></a>');
                    
                    //$('#nav-tabContent-frd').append('<div class=\"tab-pane fade in show\" id=\"list-' + data + '\" role=\"tabpanel\" aria-labelledby=\"list-' + data + '-list\"><ul id=\"list-frd\" class=\"list-group\"><li id=\"no-item\" class=\"list-group-item d-flex justify-content-between align-items-center\">No hay registros de fortalezas, recomendaciones y debilidades almacenados.</li></ul></div>');


                    $('#modal').modal('hide'); //ocultamos el modal
                    $('body').removeClass('modal-open');    //eliminamos la clase del body para poder hacer scroll
                    $('.modal-backdrop').remove();  //eliminamos el backdrop del modal
                        

                    swal({
                        title: 'Enhorabuena!',
                        text: 'Se agrego satisfactoriamente.',
                        type: 'success',
                        allowOutsideClick: false,
                        timer: 1000,
                    });
                    
                    location.reload(false);
                }
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                    $('#info').html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                    $('#info').html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                }
            }
    
        });
        
    });

});

");

?>

 <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'enableAjaxValidation' => true,
        //'action' => Url::toRoute('user/ajaxregistration'),
        //'validationUrl' => Url::toRoute('save'),

        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['id' => 'acudiente']
    ]); ?>


    <div class="row">

        <div class="col-sm-2 hidden-xs">
            <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
        </div>

        <div class="col-sm-10 col-xs-12">

            <div class="row">

                <div class = "col-sm-12">
                    <?= $form->errorSummary($model); ?>

                    <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
                </div>
            </div>    
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($model, 'tipo')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Tipodocumento::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                        'options' => ['placeholder' => 'Seleccione el Tipo de Documento'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-6">
                    <?= $form->field($model, 'identificacion')->textInput(['maxlength' => true, 'placeholder' => 'Número de Identificación']) ?>
                </div>       
            </div>    
            <div class="row">    
                <div class="col-sm-3">
                    <?= $form->field($model, 'primer_nombre')->textInput(['maxlength' => true, 'placeholder' => 'Primer Nombre']) ?>
                </div>       
                
                <div class="col-sm-3">
                    <?= $form->field($model, 'segundo_nombre')->textInput(['maxlength' => true, 'placeholder' => 'Segundo Nombre']) ?>
                </div>       
                
                <div class="col-sm-3">
                    <?= $form->field($model, 'primer_apellido')->textInput(['maxlength' => true, 'placeholder' => 'Primer Apellido']) ?>
                </div>       
                
                <div class="col-sm-3">
                    <?= $form->field($model, 'segundo_apellido')->textInput(['maxlength' => true, 'placeholder' => 'Segundo Apellido']) ?>
                </div>       
            </div>    
            <div class="row">    
                <div class="col-sm-3">
                    <?= $form->field($model, 'genero')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Genero::find()->orderBy('id')->asArray()->all(), 'id', 'genero'),
                        'options' => ['placeholder' => 'Seleccione el Género'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>       
                
                <div class="col-sm-3">
                    <?= $form->field($model, 'parentesco')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Parentesco::find()->orderBy('id')->asArray()->all(), 'id', 'parentesco'),
                        'options' => ['placeholder' => 'Seleccione el Parentesco'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>       
                
                <div class="col-sm-6">
                    <?= $form->field($model, 'rh')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Rh::find()->orderBy('id')->asArray()->all(), 'id', 'rh'),
                        'options' => ['placeholder' => 'Seleccione el Grupo Sanguineo y RH'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ]) ?>
                </div>       
            </div>    
            <div class="row">    
                <div class="col-sm-6">
                    <?= $form->field($model, 'fijo')->textInput(['maxlength' => true, 'placeholder' => 'Fijo']) ?>
                </div>       
                
                <div class="col-sm-6">
                    <?= $form->field($model, 'movil')->textInput(['maxlength' => true, 'placeholder' => 'Móvil']) ?>
                </div>       
            </div>    
            <div class="row">    
                <div class="col-sm-6">
                    <?= $form->field($model, 'direccion')->textInput(['maxlength' => true, 'placeholder' => 'Dirección']) ?>
                </div>   
                <div class="col-sm-6">
                    <?= $form->field($model, 'email')->textInput(['maxlength' => true, 'placeholder' => 'Email']) ?>
                </div>       
            </div>
        

            <div class="row">    
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align:right; padding-top: 10px;">
                    <?= Html::Button($model->isNewRecord ? '<i class="glyphicon glyphicon-plus"></i>' . ' Agregar' : '<i class="glyphicon glyphicon-pencil"></i>' . ' Actualizar', ['type' => 'button', 'class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-success', 'id' => 'aplicar']) ?>
                    <?= Html::a('<i class="fa fa-times" aria-hidden="true"></i><span> Cancelar', false , ['class'=> 'btn btn-danger', 'data-dismiss' => 'modal']) ?>        
                </div>
            </div>
        
    </div>
        
    <?= $form->field($model, 'estudiante')->hiddenInput(['value'=> $model->estudiante])->label(false); ?>
<?php ActiveForm::end(); ?>
