<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use kartik\switchinput\SwitchInput;
use kartik\widgets\ColorInput;
use kartik\widgets\Select2;
use kartik\daterange\DateRangePicker;

?>



<?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Eventos</h3>
    </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'evento')->textInput(['placeholder' => 'Evento']) ?>
            </div>       
            <div class="col-sm-6">
            <?= $form->field($model, 'grupo')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->orderBy('id')->asArray()->all(), 'id', 'grupo'),
                'options' => ['placeholder' => 'Seleccione'],
                'pluginOptions' => [
                    'allowClear' => true,
                    'multiple' => true,
                ],
            ]) ?>
            </div> 
        </div>
        <div class="row">
            <div class="col-sm-6">
                <label>Disponible Desde y Hasta</label>    

                    <?php
                        $addon = '<span class="input-group-addon">
                                    <i class="glyphicon glyphicon-calendar"></i>
                                </span>';

                        echo '<div class="input-group drp-container">';

                        if ($model->isNewRecord)
                        {
                            date_default_timezone_set('America/Bogota');    
                            $model->fecha_inicio = date('Y-m-d H:i:s', strtotime( 'monday this week' ) );
                            $model->fecha_fin = date('Y-m-d H:i:s', strtotime( 'friday this week' ) );

                            $model->rango = $model->fecha_inicio." - ".$model->fecha_fin;
                        }    

                        
                        echo DateRangePicker::widget([
                            'model'=>$model,
                            'attribute' => 'rango',
                            'useWithAddon'=>true,
                            'autoUpdateOnInit'=>true,
                            'convertFormat'=>true,
                            'presetDropdown' => false,
                            'startAttribute' => 'fecha_inicio',
                            'endAttribute' => 'fecha_fin',
                            'pluginOptions'=>[
                                'timePicker' => true,
                                'locale'=>[
                                    'format' => 'Y-m-d H:i:s',
                                    'separator'=> ' al ',
                                ],                                        
                            ]
                        ]) . $addon;
                        echo '</div>';
                    ?>
            </div>     

            <div class="col-sm-6">
                <?= $form->field($model, 'color')->widget(ColorInput::classname(), [
                         'options' => ['placeholder' => 'Seleccione el Color', 'readonly' => true],
                         'pluginOptions' => [
                                'allowClear' => true
                          ],
                        ]);
                ?>
            </div> 
        </div>
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'tipo_tercero')->widget(\kartik\widgets\Select2::classname(), [
                    'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipotercero::find()->where(['<', 'id', '4'])->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                    'options' => ['placeholder' => 'Seleccione'],
                    'pluginOptions' => [
                        'allowClear' => true,
                        'multiple' => true,
                    ],
                ]) ?>
            </div>       

            <div class="col-sm-3">     
                <?= $form->field($model, 'publico')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'medium',
                    'onColor' => 'success',
                    'offColor' => 'danger',
                    'onText'=>'Si',
                    'offText'=>'No'
                ]]) 
                ?>
            </div>
            <div class="col-sm-3">     
                
                <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

                <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'medium',
                    'onColor' => 'success',
                    'offColor' => 'danger',
                    'onText'=>'Activo',
                    'offText'=>'Inactivo'
                ]]) 
                ?>
            </div>
        </div>

    </div>
</div>

    <?php ActiveForm::end(); ?>
