<?php

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;

$this->title = 'Agenda Académica';
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];

$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="agenda-index">

        <div class="search-form" style="display:none">
             <?=  $this->render('_search', ['model' => $searchModel]); ?>
        </div>
        
        <?php 
    $gridColumn = [
        ['class'=>'kartik\grid\SerialColumn', 'order'=>DynaGrid::ORDER_FIX_LEFT],
        'evento',
        [
                'attribute' => 'grupo',
                'label' => 'Grupo',
                'format' => 'RAW',
                'value' => function($model){
                    if ($model->grupo == NULL)
                    {
                        return '<span class="label" style="width:50px; background-color:#AB49AE; color:#fff; margin-right:5px;">Todos</span>';
                    }    
                    else
                    {
                        $datagrupos ='';
                        $grupos = explode(',', $model->grupo);

                        foreach ($grupos as $grupo) 
                        {
                            $codgrupo = \backend\models\Grupo::find()->where(['id' => $grupo])->one();

                            $color = '#' . str_pad(dechex(mt_rand(0, 0xFFFFFF)), 6, '0', STR_PAD_LEFT);
                            
                            $datagrupos .= '<span class="label" style="width:50px; background-color:'.$color.'; color:#fff; margin-right:5px;">'.(isset($codgrupo) ? $codgrupo->grupo : 'Sin Grupo').'</span>';
                        }
                        return $datagrupos;
                    }    
                    //return $model->grupos->grupo;
                },
                'filter' => false,
                
            ],
        'fecha_inicio',
        'fecha_fin',
        [
                'attribute' => 'tipo_tercero',
                'label' => 'Visible',
                'format' => 'RAW',
                'value' => function($model){
                    if ($model->tipo_tercero == NULL)
                    {
                        return '<span class="label" style="width:50px; background-color:#AB49AE; color:#fff; margin-right:5px;">Todos</span>';
                    }    
                    else
                    {
                        $dataterceros ='';
                        $terceros = explode(',', $model->tipo_tercero);
                        foreach ($terceros as $tercero) 
                        {
                            $tipo = \backend\models\Tipotercero::find()->where(['=', 'id', $tercero])->one();
                            
                            $dataterceros .= '<span class="label" style="width:50px; background-color:#1186CC; color:#fff; margin-right:5px;">'.$tipo->tipo.'</span>';
                        }
                        return $dataterceros;
                    }    
                    //return $model->grupos->grupo;
                },
                'filter' => false,
            ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'publico', 
            'vAlign'=>'middle'
        ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class'=>'kartik\grid\ActionColumn',
            'dropdown'=>false,
            'order'=>DynaGrid::ORDER_FIX_RIGHT,
        ],
        ['class'=>'kartik\grid\CheckboxColumn',  'order'=>DynaGrid::ORDER_FIX_RIGHT],
    ]; 
    ?>
<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>true,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading'=>'<h3 class="panel-title"><i class="fa fa-calendar"></i>  Agenda Académica - Eventos</h3>',
                'before' =>  '<div style="padding-top: 7px;"><em>Agenda Académica e Institucional.</em></div>',
                'after' => false,
            ],        
            'toolbar' =>  [
                ['content'=>
                     Html::a('<i class="glyphicon glyphicon-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="glyphicon glyphicon-repeat"></i>', ['eventos'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}'],
                '{export}',
            ]
        ],
        'options'=>['id'=>'agenda'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
