<?php

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
//use edofre\fullcalendarscheduler\FullcalendarScheduler;

$this->title = 'Agenda Académica';
$this->params['breadcrumbs'][] = $this->title;

$hoy = new DateTime('now', new DateTimeZone('America/Bogota'));

?>

<script src="https://cdn.jsdelivr.net/npm/fullcalendar-scheduler@5.10.1/main.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/fullcalendar-scheduler@5.10.1/locales-all.min.js"></script>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar-scheduler@5.10.1/main.min.css">
    
    <script>

      document.addEventListener('DOMContentLoaded', function() {
        var calendarEl = document.getElementById('calendar');
        var calendar = new FullCalendar.Calendar(calendarEl, {
            schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',
            //initialView: 'dayGridMonth',
            locale: 'es',
            timeZone: 'America/Bogota',
          //initialView: 'resourceTimelineWeek'
            customButtons: {
            myCustomButton: {
                  text: 'Imprimir',
                  click: function() {
                    //alert('clicked the custom button!');
                    window.print();
                  }
                }
            },
            headerToolbar: {
                left: 'prev,next today myCustomButton',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,resourceTimelineDay,listWeek'
            },
            initialView: 'resourceTimelineDay',
            resourceAreaWidth: '15%',
            //nowIndicator: true,
            weekends: true,
            weekNumbers: false,
            weekText: true,
            weekTextLong: 'Semana', 
            
            timeFormat: 'h(:mm) a',
            axisFormat: 'HH:mm a',

            //slotLabelFormat: 'h(:mm) a',
            
            navLinks: true, // can click day/week names to navigate views
            editable: true,
            eventLimit: true, // allow "more" link when too many events
            resourceAreaHeaderContent: 'Grupos',
            resources: '<?= yii\helpers\Url::to(['agenda/resources']) ?>',
            events: '<?= \yii\helpers\Url::to(['agenda/events']) ?>',
            resourceOrder: 'id + 0',
        });
        calendar.render();
      });

    </script>

    <div id='calendar'></div>

    <?
/*
$this->registerCss("
    .fc-button {
        font-weight: 400;
        color: #212529;
        text-align: center;
        vertical-align: middle;
        padding: .4em .65em !important;
        height: auto !important;
        font-size: 1em;
        line-height: 1.5;
        
    }
    .fc-state-default {
        color: #fff;
        background-color: #2c3e50;
        border-color: #2c3e50;
        background-image:none !important;
        text-shadow:none !important;
        box-shadow:none !important;
    }
    .fc-state-default:hover {
        color: #fff;
        background-color: #1e2b37;
        border-color: #1a252f;
    }
    .fc-state-active {
        color: #fff;
        background-color: #1a252f;
        border-color: #151e27;
    }
    .fc-toolbar h2 {
        font-size: 1.75em;
        margin: 0;
    }

    .fc-resource-area .fc-icon {
        width: auto !important;
    }

");

*/

?>
<!--
<script type="text/javascript">
  $('.printBtn').on('click', function (){
    window.print();
  });
</script>
-->

<?/* FullcalendarScheduler::widget([
    'header'        => [
        'left'   => 'prev,next, today ',
        'center' => 'title',
        //'right'  => 'timelineDay,timelineThreeDays,agendaWeek,month',
        'right'  => 'timelineDay,timelineThreeDays,agendaWeek,month,listWeek',
    ],
    'clientOptions' => [
        //'schedulerLicenseKey' => 'GPL-My-Project-Is-Open-Source',
        'schedulerLicenseKey' => 'CC-Attribution-NonCommercial-NoDerivatives',
        //'eventLimit'  => true, // allow "more" link when too many events
        //'aspectRatio'       => 1.8,
        //'scrollTime'        => '06:00', // undo default 6am scrollTime
        'defaultView'       => 'timelineDay',
        //'initialView' => 'resourceTimeline',
        //'resourceLabelText' => 'Grupos',
        //'resourceAreaWidth' => '20%',
        //'nowIndicator'      => true,
        //'weekends'          => true,
        //'timeFormat'        => 'h(:mm) a',
        //'axisFormat'        => 'h(:mm) a',
        //'slotLabelFormat'   => 'h(:mm) a',
        'resources'         => \yii\helpers\Url::to(['agenda/resources', 'id' => 1]),
        'events'            => \yii\helpers\Url::to(['agenda/events', 'id' => 2]),
    ],
]);*/
?>



