<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Anexo */

$this->title = $model->anexo;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Anexo'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="anexo-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Anexo').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'oferentes.id',
            'label' => Yii::t('app', 'Oferente'),
        ],
        [
            'attribute' => 'tipoanexo.tipo',
            'label' => Yii::t('app', 'Tipo Anexo'),
        ],
        'anexo:ntext',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    <div class="row">
        <h4>TipoAnexo<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnTipoAnexo = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->tipoAnexo,
        'attributes' => $gridColumnTipoAnexo    ]);
    ?>
    <div class="row">
        <h4>Oferente<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnOferente = [
        ['attribute' => 'id', 'visible' => false],
        'tipo_persona',
        'razon_social',
        'nit',
        'fecha_inscripcion',
        'ciiu_1',
        'ciiu_2',
        'ciiu_3',
        'ciiu_4',
        'activo_corriente',
        'activo_total',
        'pasivo_corriente',
        'pasivo_total',
        'patrimonio',
        'utilidad_perdida',
        'gasto_intereses',
        'indice_liquidez',
        'indice_endeudamiento',
        'razon_cobertura',
        'rentabilidad_patrimonio',
        'rentabilidad_activo',
        'logo',
        'verificado',
        [
            'attribute' => 'estados.oferente_estado',
            'label' => Yii::t('app', 'Estado'),
        ],
        'bloqueo',
    ];
    echo DetailView::widget([
        'model' => $model->oferentes,
        'attributes' => $gridColumnOferente    ]);
    ?>
</div>
