<?php
use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;


$this->title = $model->area;
$this->params['breadcrumbs'][] = ['label' => 'Áreas Académicas', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->area, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = 'Ver';
?>
<div class="area-view">

    <div class="row">
<?php 
    /*
    if ($model->tipo_tercero==1) $color="success";
    if ($model->tipo_tercero==2) $color="info";
    if ($model->tipo_tercero==3) $color="warning";
    if ($model->tipo_tercero==4) $color="danger";
*/
    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute'=>'area',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],
                
            ],
        ], 
        [
            'columns' => [
                [
                    'attribute' => 'estado',
                    'format' => 'RAW',
                    'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>',
                    'valueColOptions'=>['style'=>'width:80%'],
                ],   
            ],
        ],
           
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerAsignatura->totalCount){
    $gridColumnAsignatura = [
        ['class' => 'yii\grid\SerialColumn'],
            'asignatura',
            'codigo',
            'intensidad',
            [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
            [
                'attribute' => 'area.area',
                'label' => 'Area'
        ],
            [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>'
        ], 
    ];
    echo Gridview::widget([
        'dataProvider' => $providerAsignatura,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-asignatura']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Asignatura'.' '. $this->title),
        ],
        'columns' => $gridColumnAsignatura
    ]);
}
?>
    </div>
</div>