<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\TouchSpin;
use kartik\widgets\DepDrop;

use backend\models\Grado;
use backend\models\Area;
use backend\models\Especialidad;


?>

<?php $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); ?>


<div class="asignatura-form">


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Asignatura</h3>
    </div>

    <div class="panel-body" >

            <?= $form->errorSummary($model); ?>

    <div class="col-sm-6">

        <?= $form->field($model, 'asignatura')->textInput(['maxlength' => true, 'placeholder' => 'Asignatura']) ?>
 
    </div>       
    <div class="col-sm-3">
 
       <?= $form->field($model, 'codigo')->textInput(['maxlength' => true, 'placeholder' => 'Abreviatura']) ?>

    </div>       
    <div class="col-sm-3">

        <?= $form->field($model, 'intensidad')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Horas'],]);?>

    </div>       
    <div class="col-sm-6">
        <?= $form->field($model, 'grado')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Grado::find()->orderBy('id')->asArray()->all(), 'id', 'grado'),
            'pluginOptions' => [
                'placeholder' => 'Seleccione el Grado',
                'allowClear' => true,
            ],
        ]) ?>
    </div>
    <div class="col-sm-3">    
        <?= $form->field($model, 'area')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Area::find()->orderBy('id')->asArray()->all(), 'id', 'area'),
            'pluginOptions' => [
                'placeholder' => 'Seleccione el Área',
                'allowClear' => true,
            ],
        ]) ?>
    </div>
    <div class="col-sm-3">  
        <?= $form->field($model, 'especialidad')->widget(Select2::classname(), [
            'data' => ArrayHelper::map(Especialidad::find()->orderBy('id')->asArray()->all(), 'id', 'especialidad'),
            'options' => ['placeholder' => 'Seleccione Especialidad'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    </div>

    <div class="col-sm-3">        
        <?= $form->field($model, 'num_calificaciones_saber')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Número'],]);?>
    </div> 

    <div class="col-sm-3">        
        <?= $form->field($model, 'por_calificaciones_saber')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Porcentaje'],]);?>
    </div>

    <div class="col-sm-3">        
        <?= $form->field($model, 'num_calificaciones_ser')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Número'],]);?>
    </div> 
    
    <div class="col-sm-3">        
        <?= $form->field($model, 'por_calificaciones_ser')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Porcentaje'],]);?>
    </div>
    <div class="col-sm-3">        
        <?= $form->field($model, 'por_calificaciones_psi')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Porcentaje'],]);?>
    </div>

    <div class="col-sm-3">        
        <?= $form->field($model, 'por_asig_area')->widget(TouchSpin::classname(), ['options' => ['placeholder' => 'Porcentaje'],]);?>
    </div>
    
    <div class="col-sm-3">     
        
        <?= $form->field($model, 'principal')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'primary',
            'offColor' => 'warning',
            'onText'=>'Principal',
            'offText'=>'Complementaria'
        ]]) 
        ?>
    </div>

    <div class="col-sm-3">     
        
        <?= $form->field($model, 'excluida_promocion')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'primary',
            'offColor' => 'warning',
            'onText'=>'Excluida',
            'offText'=>'No Excluida'
        ]]) 
        ?>
    </div>
    
    <div class="col-sm-3">     
        
        <? ($model->isNewRecord) ? $model->estado = true: ''; ?>

        <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
            'size' => 'medium',
            'onColor' => 'success',
            'offColor' => 'danger',
            'onText'=>'Activo',
            'offText'=>'Inactivo'
        ]]) 
        ?>
    </div>


    </div>
</div>     

    <?php ActiveForm::end(); ?>

</div>
