<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Asignatura */

$this->title = $model->asignatura;
$this->params['breadcrumbs'][] = ['label' => 'Asignaturas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="asignatura-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Asignatura'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'asignatura',
        'codigo',
        'intensidad',
        [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'area.area',
                'label' => 'Area'
        ],
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
  
</div>
