<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Asistencia */

?>
<div class="asistencia-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Html::encode($model->id) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        [
            'attribute' => 'asignaturas.asignatura',
            'label' => 'Asignatura',
        ],
        [
            'attribute' => 'grupos.grupo',
            'label' => 'Grupo',
        ],
        [
            'attribute' => 'periodos.periodo',
            'label' => 'Periodo',
        ],
        [
            'attribute' => 'docente',
            'label' => 'Docente',
            'value'=>$model->docentes->nombre,
        ],
        [
            'attribute' => 'estudiante',
            'label' => 'Estudiante',
            'value'=>$model->estudiantes->nombre,
        ],
        'asistio',
        'fallas',
        [
            'attribute' => 'tipoInasistencias.tipo_inasistencia',
            'label' => 'Tipo Inasistencia',
        ],
        'fecha',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
</div>