<?php
########################################################
#                                                      #
#               GOOD SOLUTIONS COLOMBIA                #
#            www.gsol.co - contacto@gsol.co            #
#                     GSOL Colombia                    #
#                   N.I.T 900065739-7                  #
########################################################

use yii\helpers\Html;
use yii\widgets\ListView;
use yii\widgets\Pjax;
use kartik\widgets\ActiveForm;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Carga;


$this->title = 'Toma de Asistencia';
$this->params['breadcrumbs'][] = ['label' => 'Panel del Docente', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Guardar', 'url' => false, 'action' => 'guardar', 'icon' => '<i class="far fa-check"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Cancelar', 'url' => ['docente/index'], 'icon' => '<i class="far fa-times"></i>', 'class' => 'danger'];

//echo "<br>Session 1 :".Yii::$app->session->getId(); 
?>


<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="demo-btn-group">
            <div class="callout callout-success">
                <div class="row"> 
                    <div class="col-sm-12">
                        <h4>
                            <?
                                $docente = Carga::find()->where(['asignatura' => Yii::$app->request->get('asignatura'), 'grupo' => Yii::$app->request->get('grupo')])->one(); 

                                echo (isset($docente)) ? $docente->docentes->nombre : 'Sin Docente Asignado';
                            ?>
                        </h4>
                    </div>
                </div>
                <div class="row"> 
                    <div class="col-sm-4">
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-chalkboard-teacher fa-lg text-warning"></i>
                            <? 
                                $asignatura = Asignatura::findOne(Yii::$app->request->get('asignatura'));
                                echo $asignatura->asignatura.' <small class="text-success">'.$asignatura->especialidades->especialidad.'</small>';
                            ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-users fa-lg text-primary"></i>
                            <?= "Grupo ".$docente->grupos->grupo; ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-clock fa-lg text-danger"></i>
                            <?= "Periodo ".$periodo->actual->id; ?>
                        </h5>
                    </div>
                    <div class="col-sm-4">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-pencil fa-lg text-success"></i>
                            <?= ($grupo->grados->calificacionxcompetencia == 1) ? '<span class="label label-primary">Calificación por Asignatura</span' : '<span class="label label-success">Calificación por Competencia</span>'; ?>    
                            &nbsp; 
                            <?= '<span class="label label-info">'.$grupo->grados->tipoCalificaciones->tipo.'</span>'; ?>
                        </h5>
                    </div>
                </div>    
            </div>
        </div>
    </div>
</div>
<br>

<div class="row">
  <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
    <? 
        $form = ActiveForm::begin([
                'validateOnSubmit' => true,
                'type' => ActiveForm::TYPE_VERTICAL,
                'options' => ['class' => 'main-task-form',
                              'id' => 'formulario',
                            ]
            ]);
    ?>  

    <?= $form->errorSummary($asistencias); ?>
      
      
    <?= ListView::widget([
        'dataProvider' => $dataProvider,
        'viewParams' => ['asistencias' => $asistencias, 'form' => $form, 'periodo' => $periodo->actual->id],
        'itemView' => '_list_asistencia',
        'layout' => "{pager}\n{items}\n{summary}",
        'summary'=>'', 
    ]);
        
   // echo "<br>Session 2 :".Yii::$app->session->getId(); 
    ?>

    <? ActiveForm::end(); ?>
      
  </div>        
</div>