<?php

use yii\helpers\Html;

use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;

use yii\helpers\Url;

    
    $gridColumn = [
        [
            'attribute' => 'name',
            'label' => 'Nombre',
        ],
        [
            'attribute' => 'size',
            'label' => 'Tamaño',
            'value' => function($model){
                Yii::$app->formatter->sizeFormatBase = 1000;
                return Yii::$app->formatter->asSize($model['size'],1);

            },
        ],
        [
            'attribute' => 'create_time',
            'label' => 'Creado El',
        ],
        [
            'attribute' => 'modified_time',
            'label' => 'Tiempo Creado',
            'value' => function($model){
                        return Yii::$app->formatter->asRelativeTime($model['modified_time']);

            },
        ],
        [
            'class' => 'kartik\grid\ActionColumn',
            'template' => '{restore_action}',
            'header' => 'Restaurar',
            'buttons' => [
                'restore_action' => function ($url, $model) {
                    return Html::a('<i class="fas fa-window-restore"></i>', $url, [
                                'title' => 'Restaurar',
                    ]);
                }
                    ],
                    'urlCreator' => function ($action, $model, $key, $index) {
                if ($action === 'restore_action') {
                    $url = Yii::$app->urlManager->createUrl(['backuprestore/default/restore', 'filename' => $model['name']]);
                    return $url;
                }
            }
        ],
        [
            'class' => 'kartik\grid\ActionColumn',
            'template' => '{delete_action}',
            'header' => 'Eliminar',
            'buttons' => [
                'delete_action' => function ($url, $model) {
                    return Html::a('<span class="glyphicon glyphicon-trash"></span>', $url, [
                                'title' => 'Eliminar este archivo',
                    ]);
                }
            ],
            'urlCreator' => function ($action, $model, $key, $index) {
                if ($action === 'delete_action') {
                    return Url::to(['delete', 'file' => $model['name']]);;
                }
            }
        ],
    ];
?>



<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fas fa-database"></i> Backup', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success create-backup', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fas fa-cloud-upload-alt"></i> Subir', ['upload'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Subir'])

                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'backup'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>