<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->terceros,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        'identificacion',
        [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        [
                'attribute' => 'generos.genero',
                'label' => 'Genero'
        ],
        [
                'attribute' => 'tipo_tercero',
                'label' => 'Tipo Tercero',
                'format' => 'RAW',
                'value' => function($model){
                    if ($model->tipo_tercero==1) $color="success";
                    if ($model->tipo_tercero==2) $color="info";
                    if ($model->tipo_tercero==3) $color="warning";
                    if ($model->tipo_tercero==4) $color="danger";  

                    return '<span class="label label-'.$color.'">'.$model->tipoterceros->tipo.'</span>';
                },
        ],/*
        [
                'attribute' => 'parentesco.parentesco',
                'label' => 'Parentesco'
        ],
        'fecha_nacimiento',
        [
                'attribute' => 'departamentos.nombre',
                'label' => 'Departamento Nacimiento'
        ],
        [
                'attribute' => 'municipios.nombre',
                'label' => 'Municipio Nacimiento'
        ],
        [
                'attribute' => 'rhs.rh',
                'label' => 'Rh'
        ],
        [
                'attribute' => 'religiones.religion',
                'label' => 'Religion'
        ],
        [
                'attribute' => 'etnias.etnia',
                'label' => 'Etnia'
        ],
        [
                'attribute' => 'epss.eps',
                'label' => 'Eps'
        ],
        'direccion',
        'fijo',
        'movil',
        'email:email',
        'foto',
        'acudiente',*/
        [
                'attribute' => 'estado',
                'label' => 'Estado',
                'format' => 'raw',
                'value' => function($model){
                    if ($model->estado==1) $color="success";
                    if ($model->estado==2) $color="info";
                    if ($model->estado==3) $color="warning";
                    if ($model->estado==4) $color="danger"; 
                    
                    if ($model->estado==5 or $model->estado==7 or $model->estado==9) $color="success";
                    if ($model->estado==6 or $model->estado==8 or $model->estado==10) $color="danger"; 

                    return '<span class="label label-'.$color.'">'.$model->estados->estado.'</span>';
                },
        ],
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'tercero'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
