<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\Departamento;
use backend\models\Municipio;
use backend\models\Comuna;

?>
<div class="barrio-view">


    <div class="row">
<?php 
    /*
    if ($model->tipo_tercero==1) $color="success";
    if ($model->tipo_tercero==2) $color="info";
    if ($model->tipo_tercero==3) $color="warning";
    if ($model->tipo_tercero==4) $color="danger";
*/
    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute'=>'nombre',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'departamento',
                    'label' => 'Departamento',
                    'value'=>$model->departamentos->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Departamento::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
                
            ],
        ], 
        [
            'columns' => [
                [
                    'attribute' => 'municipio',
                    'label' => 'Municipio',
                    'value'=>$model->municipios->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Municipio::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
                [
                    'attribute' => 'comuna',
                    'label' => 'Comuna',
                    'value'=>$model->comunas->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Comuna::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],  
            ],
        ],
           
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>
    </div>
</div>