<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

Pjax::begin();
$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Tercero',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        'identificacion' => ['type' => TabularForm::INPUT_TEXT],
        'tipo' => [
            'label' => 'Tipo documento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipodocumento::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tipo documento'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'primer_nombre' => ['type' => TabularForm::INPUT_TEXT],
        'segundo_nombre' => ['type' => TabularForm::INPUT_TEXT],
        'primer_apellido' => ['type' => TabularForm::INPUT_TEXT],
        'segundo_apellido' => ['type' => TabularForm::INPUT_TEXT],
        'genero' => [
            'label' => 'Genero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Genero::find()->orderBy('genero')->asArray()->all(), 'id', 'genero'),
                'options' => ['placeholder' => 'Choose Genero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'tipo_tercero' => [
            'label' => 'Tipo tercero',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tipotercero::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tipo tercero'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'parentesco' => [
            'label' => 'Parentesco',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Parentesco::find()->orderBy('parentesco')->asArray()->all(), 'id', 'parentesco'),
                'options' => ['placeholder' => 'Choose Parentesco'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'fecha_nacimiento' => ['type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\DatePicker::classname(),
            'options' => [
                'options' => ['placeholder' => 'Choose Fecha Nacimiento'],
                'type' => \kartik\widgets\DatePicker::TYPE_COMPONENT_APPEND,
                'pluginOptions' => [
                    'autoclose' => true,
                    'format' => 'dd-M-yyyy'
                ]
            ]
        ],
        'departamento_nacimiento' => [
            'label' => 'Departamento',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Departamento::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Departamento'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'municipio_nacimiento' => [
            'label' => 'Municipio',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Municipio::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Municipio'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'rh' => [
            'label' => 'Rh',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Rh::find()->orderBy('rh')->asArray()->all(), 'id', 'rh'),
                'options' => ['placeholder' => 'Choose Rh'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'religion' => [
            'label' => 'Religion',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Religion::find()->orderBy('religion')->asArray()->all(), 'id', 'religion'),
                'options' => ['placeholder' => 'Choose Religion'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'etnia' => [
            'label' => 'Etnia',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Etnia::find()->orderBy('etnia')->asArray()->all(), 'id', 'etnia'),
                'options' => ['placeholder' => 'Choose Etnia'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'eps' => [
            'label' => 'Eps',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Eps::find()->orderBy('eps')->asArray()->all(), 'id', 'eps'),
                'options' => ['placeholder' => 'Choose Eps'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'direccion' => ['type' => TabularForm::INPUT_TEXT],
        'fijo' => ['type' => TabularForm::INPUT_TEXT],
        'movil' => ['type' => TabularForm::INPUT_TEXT],
        'email' => ['type' => TabularForm::INPUT_TEXT],
        'foto' => ['type' => TabularForm::INPUT_TEXT],
        'acudiente' => ['type' => TabularForm::INPUT_TEXT],
        'estado' => [
            'label' => 'Tercero estado',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\TerceroEstado::find()->orderBy('id')->asArray()->all(), 'id', 'id'),
                'options' => ['placeholder' => 'Choose Tercero estado'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowTercero(' . $key . '); return false;', 'id' => 'tercero-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . 'Tercero',
            'type' => GridView::TYPE_INFO,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Row', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowTercero()']),
        ]
    ]
]);
Pjax::end();
?>
