<?php

use yii\helpers\Html;
use kartik\detail\DetailView;
use kartik\grid\GridView;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\helpers\Json;

use backend\models\Departamento;
use backend\models\Municipio;
use backend\models\Comuna;

$this->title = $model->nombre;
$this->params['breadcrumbs'][] = ['label' => 'Barrios', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Ver';
?>
<div class="barrio-view">


    <div class="row">

<?php 
    /*
    if ($model->tipo_tercero==1) $color="success";
    if ($model->tipo_tercero==2) $color="info";
    if ($model->tipo_tercero==3) $color="warning";
    if ($model->tipo_tercero==4) $color="danger";
*/
    $gridColumn = [
        [
            'group'=>true,
            'label'=>'Información Básica',
            'rowOptions'=>['class'=>'info']
        ],
        [
            'columns' => [
                [
                    'attribute'=>'nombre',
                    'valueColOptions'=>['style'=>'width:30%'],
                ],
                [
                    'attribute' => 'departamento',
                    'label' => 'Departamento',
                    'value'=>$model->departamentos->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Departamento::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
                
            ],
        ], 
        [
            'columns' => [
                [
                    'attribute' => 'municipio',
                    'label' => 'Municipio',
                    'value'=>$model->municipios->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Municipio::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],
                [
                    'attribute' => 'comuna',
                    'label' => 'Comuna',
                    'value'=>$model->comunas->nombre,
                    'valueColOptions'=>['style'=>'width:30%'],
                    'type'=>DetailView::INPUT_SELECT2, 
                    'widgetOptions'=>[
                      'data'=>ArrayHelper::map(Comuna::find()->asArray()->all(), 'id', 'nombre'),
                    ],
                ],  
            ],
        ],
           
 ];

    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn,
        'mode' => 'view',
        'enableEditMode' => false,
        'bordered' => true,
        'striped' => false,
        'panel' => [
            'heading' => 'Información Detallada',
            'type' => DetailView::TYPE_SUCCESS,
        ],
        'condensed' => false,
        'responsive' => true,
        'hover' => true,
        'hAlign'=> 'center',
        'vAlign'=> 'center',
        'fadeDelay'=> '1000',
        'deleteOptions'=>[ // your ajax delete parameters
            //'params' => ['id' => 1000, 'kvdelete'=>true],
                'params' => ['custom_param'=>true],
                'url'=>['delete', 'id' => $model->id],
        ],
        'container' => ['id'=>'kv-demo'],
        'formOptions' => ['action' => Url::current(['#' => 'delete'])] // your action to delete
    ]);
?>

    </div>
    
    <div class="row">
<?php
if($providerTercero->totalCount){
    $gridColumnTercero = [
        ['class' => 'yii\grid\SerialColumn'],
            'identificacion',
            [
                'attribute' => 'tipos.tipo',
                'label' => 'Tipo'
        ],
            'primer_nombre',
            'segundo_nombre',
            'primer_apellido',
            'segundo_apellido',
            [
                'attribute' => 'genero.genero',
                'label' => 'Genero'
        ],
            [
                'attribute' => 'tipoTercero.id',
                'label' => 'Tipo Tercero'
        ],
            [
                'attribute' => 'parentesco.parentesco',
                'label' => 'Parentesco'
        ],
            'fecha_nacimiento',
            [
                'attribute' => 'departamento.id',
                'label' => 'Departamento Nacimiento'
        ],
            [
                'attribute' => 'municipio.id',
                'label' => 'Municipio Nacimiento'
        ],
            [
                'attribute' => 'rh.rh',
                'label' => 'Rh'
        ],
            [
                'attribute' => 'religion.religion',
                'label' => 'Religion'
        ],
            [
                'attribute' => 'etnia.etnia',
                'label' => 'Etnia'
        ],
            [
                'attribute' => 'epss.eps',
                'label' => 'Eps'
        ],
            'direccion',
            [
                'attribute' => 'barrio.id',
                'label' => 'Barrio'
        ],
            'fijo',
            'movil',
            'email:email',
            'foto',
            'acudiente',
            [
                'attribute' => 'terceroEstado.id',
                'label' => 'Estado'
        ],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerTercero,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-tercero']],
        'panel' => [
        'type' => GridView::TYPE_PRIMARY,
        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Tercero'.' '. $this->title),
        ],
        'columns' => $gridColumnTercero
    ]);
}
?>
    </div>
</div>