<?php

/* @var $this yii\web\View */
/* @var $searchModel backend\models\BitacoraSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;


$this->title = Yii::t('app', 'Bitacora');
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Timeline', 'url' => 'timeline', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>
<div class="bitacora-index">

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>

    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'accion',
        'controlador',
        [
                'attribute' => 'tercero',
                'label' => Yii::t('app', 'Tercero'),
                'value' => function($model){
                    if ($model->terceros)
                    {return $model->terceros->nombre;}
                    else
                    {return NULL;}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '1', 'tipo_tercero' => '1'])->asArray()->all(), 'id', 'nombre'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-bitacora-search-tercero']
            ],
        [
                'attribute' => 'periodo',
                'label' => Yii::t('app', 'Periodo'),
                'value' => function($model){                   
                    return $model->periodos->periodo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->asArray()->all(), 'id', 'periodo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Periodo', 'id' => 'grid-bitacora-search-periodo']
            ],
        [
                'attribute' => 'descripcion',
                'label' => Yii::t('app', 'Descripción'),
                'format' => 'raw',
        ],
        [
                'attribute' => 'ejecutor',
                'label' => Yii::t('app', 'Ejecutor'),
                'value' => function($model){                   
                    return $model->tercero ? $model->ejecutores->nombre : '';
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where([ 'tipo_tercero' => '3'])->asArray()->all(), 'id', 'nombre'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Tercero', 'id' => 'grid-bitacora-search-ejecutor']
            ],
        [
                'attribute' => 'creado_el',
                'label' => Yii::t('app', 'Fecha'),
                'filterType' => GridView::FILTER_DATE,
                'filterWidgetOptions' => [
                    'language' => 'es',
                    'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true,'autoclose' => true],
                ],
                'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-observador-search-fecha']
               
            ],
    ]; 
    ?>

<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'bitacora'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>


</div>
