<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use dosamigos\tinymce\TinyMce;
use yii\web\JsExpression;
use backend\models\Blogcategoria;



?>

     <?php $form = ActiveForm::begin([
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>
    
<div class="row">
    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
    <div class="col-sm-12">
        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

        <?= $form->field($model, 'titulo')->textInput(['maxlength' => true, 'placeholder' => 'Titulo']) ?>
    </div>
</div>


<div class="row gutter">

  <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">
    <ul class="nav nav-tabs">
        <li class="active"><a data-toggle="tab" href="#tab-1">Artículo</a></li>
        <li><a data-toggle="tab" href="#tab-2">Imagen</a></li>
        <li><a data-toggle="tab" href="#tab-3">Adjuntos</a></li>
    </ul>

    <div class="tab-content">
        <div id="tab-1" class="tab-pane active">
            <div class="row">
                <div class="col-sm-12">     
                    <?= $form->field($model, 'introduccion')->widget(TinyMce::className(), [
                            'options' => ['rows' => 15],
                            'language' => 'es',
                            'clientOptions' => [
                                'plugins' => [
                                    "advlist autolink lists link charmap print preview anchor",
                                    "searchreplace visualblocks code fullscreen",
                                    "insertdatetime media image table contextmenu paste"
                                ],
                                'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
                            ]
                        ])->label();?>
                </div>        
                <div class="col-sm-12">     
                    <?= $form->field($model, 'contenido')->widget(TinyMce::className(), [
                            'options' => ['rows' => 15],
                            'language' => 'es',
                            'clientOptions' => [
                                'plugins' => [
                                    "advlist autolink lists link charmap print preview anchor",
                                    "searchreplace visualblocks code fullscreen",
                                    "insertdatetime media image table contextmenu paste"
                                ],
                                'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
                            ]
                        ])->label();?>
                </div>        
            </div>
        </div>  <!-- FIN TAB 1  -->


        <div id="tab-2" class="tab-pane">
            <div class="row">
                <div class="col-sm-12">
                    <?= $form->field($model, 'imagen')->widget(FileInput::classname(), [
                        'options' => ['accept'=>'image/*'],
                        'pluginOptions'=>[
                            'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp'],
                            'previewFileType' => 'any',
                            'showUpload' => false,
                            'initialPreview' => [
                                $model->imagen ? Html::img('@web/uploads/blog/sm-'.$model->imagen) : null, // checks the models to display the preview
                            ],
                            'overwriteInitial' => false,
                            'browseClass' => 'btn btn-primary',
                            'uploadClass' => 'btn btn-success',
                            'removeClass' => 'btn btn-danger',
                            ],
                    ]); ?>
                </div>
            </div>                
        </div>  <!-- FIN TAB 3 --> 



        <div id="tab-3" class="tab-pane">
            <div class="row">
                <div class="col-sm-12">
                    <?= $form->field($model, 'adjuntos[]')->widget(FileInput::classname(), [
                            'options' => ['multiple'=>true],
                            'pluginOptions'=>[
                                //'uploadUrl' => Url::to(['/site/file-upload']),
                                //'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp','pdf','doc', 'docx','xls'],
                                'previewFileType' => 'any',
                                'showUpload' => false,
                                'overwriteInitial' => false,
                                'browseClass' => 'btn btn-primary',
                                'uploadClass' => 'btn btn-success',
                                'removeClass' => 'btn btn-danger',
                                ],
                        ])->label('Adjuntos:'); ?>
                </div>
            </div>                
        </div>  <!-- FIN TAB 3 --> 
    </div>
  </div>


  <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
    <div class="thumbnail" style="padding: 20px !important;">
      
        <?= Html::img('@web/images/user.jpg', ['class'=>'foto-perfil img-circle img-responsive']); ?>
  
       <!-- <div class="progress m-t-xs full progress-small">
            <div style="width: 65%" aria-valuemax="100" aria-valuemin="0" aria-valuenow="65" role="progressbar" class=" progress-bar progress-bar-success">
                <span class="sr-only">35% Complete (success)</span>
            </div>
        </div>
        -->

        <?php if(Yii::$app->controller->action->id != 'save-as-new'): ?>
            <? Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        <?php endif; ?>

        <?php if(Yii::$app->controller->action->id != 'create'): ?>
                    <? Html::submitButton('Guardar como Copia', ['class' => 'btn btn-block btn-info', 'value' => '1', 'name' => '_asnew']) ?>
                <?php endif; ?>
                <br>
        <?php

            if (Yii::$app->session->get('__tipo') == 1) 
            {
                $categorias = Blogcategoria::find()->where(['>','id', '1'])->orderBy('id')->asArray()->all();
            }
            else
            {
                $categorias = Blogcategoria::find()->orderBy('id')->asArray()->all();
            }
            
            echo $form->field($model, 'categoria')->widget(\kartik\widgets\Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map($categorias, 'id', 'categoria'),
                'options' => ['placeholder' => 'Categoría'],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]);
            

            echo  $form->field($model, 'inicio')->widget(SwitchInput::classname(), ['pluginOptions' => [
                'size' => 'medium',
                'onColor' => 'success',
                'offColor' => 'danger',
                'onText'=>'Si',
                'offText'=>'No'
            ]]);
            if ($model->isNewRecord){ $model->estado = '1'; }

            echo  $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                'size' => 'medium',
                'onColor' => 'success',
                'offColor' => 'danger',
                'onText'=>'Activo',
                'offText'=>'Inactivo'
            ]]);

                if($model->aprobado == 1)
                {
                    echo "<label class='btn btn-block btn-success'>Aprobado</label>";    
                }
                else
                {
                    echo "<label class='btn btn-block btn-danger'>Sin Aprobar </label>";
                }
            
                echo "<label class='btn btn-block btn-primary'><i class='far fa-eye'></i> ".$model->visto."</label>";    
            ?>

                
                
                
    </div>
  </div>
</div>
        <?
            if($model->isNewRecord)
            {
                if (Yii::$app->session->get('__tipo') == 1)
                {
                    echo $form->field($model, 'aprobado')->hiddenInput(['value'=> '1'])->label(false);    
                }
                else
                {
                    echo $form->field($model, 'aprobado')->hiddenInput(['value'=> '0'])->label(false);       
                }

                if (Yii::$app->session->get('__doc') == 'admin')
                {
                    echo $form->field($model, 'aprobado')->hiddenInput(['value'=> '1'])->label(false);    
                }    
                
                echo $form->field($model, 'visto')->hiddenInput(['value'=> '0'])->label(false);
            }
        ?>
        
    <?php ActiveForm::end(); ?>
