<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Blogcategoria */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Blogcategoria', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="blogcategoria-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Blogcategoria'.' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Delete', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Are you sure you want to delete this item?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'categoria',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'eliminado_el',
        'eliminado_por',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerBlog->totalCount){
    $gridColumnBlog = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'titulo',
                        'introduccion:ntext',
            'contenido:ntext',
            'imagen',
            'adjuntos:ntext',
            'visto',
            'aprobado',
            'creado_el',
            'creado_por',
            'actualizado_el',
            'actualizado_por',
            'eliminado_el',
            'eliminado_por',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerBlog,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-blog']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Blog'),
        ],
        'export' => false,
        'columns' => $gridColumnBlog
    ]);
}
?>

    </div>
</div>
