<?php
########################################################
#                                                      #
#               GOOD SOLUTIONS COLOMBIA                #
#            www.gsol.co - contacto@gsol.co            #
#                     GSOL Colombia                    #
#                   N.I.T 900065739-7                  #
########################################################

use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\ListView;
use yii\widgets\Pjax;
use kartik\widgets\ActiveForm;
use backend\models\Grupo;
use backend\models\Area;
use backend\models\Competencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Carga;

 
$this->title = 'Áreas';
$this->params['breadcrumbs'][] = ['label' => 'Panel del Docente', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Guardar', 'url' => false, 'action' => 'guardar', 'icon' => '<i class="far fa-check"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Cancelar', 'url' => ['index'], 'icon' => '<i class="far fa-times"></i>', 'class' => 'danger'];


$this->registerCss("

  
.table > thead > tr > td.salmon, 
.table > tbody > tr > td.salmon, 
.table > tfoot > tr > td.salmon, 
.table > thead > tr > th.salmon, 
.table > tbody > tr > th.salmon, 
.table > tfoot > tr > th.salmon, 
.table > thead > tr.salmon > td, 
.table > tbody > tr.salmon > td, 
.table > tfoot > tr.salmon > td, 
.table > thead > tr.salmon > th, 
.table > tbody > tr.salmon > th, 
.table > tfoot > tr.salmon > th {
    background-color: #D291BC;
}

.table-hover > tbody > tr > td.salmon:hover, 
.table-hover > tbody > tr > th.salmon:hover, 
.table-hover > tbody > tr.salmon:hover > td, 
.table-hover > tbody > tr:hover > .salmon, 
.table-hover > tbody > tr.salmon:hover > th 
{
    background-color: #C789B2;
}
.btn-salmon{
    color: #fff;
    background-color: #8D6B82;
    border-color: #87667C;
}



.table > thead > tr > td.purple, 
.table > tbody > tr > td.purple, 
.table > tfoot > tr > td.purple, 
.table > thead > tr > th.purple, 
.table > tbody > tr > th.purple, 
.table > tfoot > tr > th.purple, 
.table > thead > tr.purple > td, 
.table > tbody > tr.purple > td, 
.table > tfoot > tr.purple > td, 
.table > thead > tr.purple > th, 
.table > tbody > tr.purple > th, 
.table > tfoot > tr.purple > th {
    background-color: #E8C2ED;
}

.table-hover > tbody > tr > td.purple:hover, 
.table-hover > tbody > tr > th.purple:hover, 
.table-hover > tbody > tr.purple:hover > td, 
.table-hover > tbody > tr:hover > .purple, 
.table-hover > tbody > tr.purple:hover > th 
{
    background-color: #E0BBE4;
}
.btn-purple{
    color: #fff;
    background-color: #92278F;
    border-color: #81227E;
}

");

?>


<script type="text/javascript">         

<?php if ($tipo_calificacion != 1){ ?>


    function promediar(id,tipo) 
    { 
        var i;
        var promedio;
        var suma_saber = 0;
        var suma_ser = 0;
        var suma_psi = 0;
        var promedio_saber = 0;
        var promedio_ser = 0;
        var promedio_psi = 0;

        for (i = 1; i <= <?= $num_calificaciones_saber ?>; i++) {
            suma_saber = suma_saber + Number(document.getElementById("promedioarea-" + id + "-promedio_estudiante-" + i).value);
            console.log('Saber id: ' + id + ' i: ' + i); 
        }

        promedio_saber = Number(((suma_saber / <?= $num_calificaciones_saber ?> ) * <?= $por_calificaciones_saber ?>) / 100); 


                

        promedio = promedio_saber + promedio_ser + promedio_psi; 

        $.ajax({
                url: '../desempeno/desempenocolor?calificacion=' + promedio +'&tipo_calificacion=' + tipo,
                success: function(color) {

                    $('#'+id).css('background-color', color);
                    console.log(color);
                },
                error: function() {
                    console.log("No se ha podido obtener la información de la fila" + id-1);
                }
            });
        
        $('#'+id).text(promedio.toFixed(1));



        if (e.keyCode == 13) {
           /* FOCUS ELEMENT */
           var inputs = $(this).parents('form').eq(0).find(':input');
           var idx = inputs.index(this);

           if (idx == inputs.length - 1) {
               inputs[0].select()
           } else {
               inputs[idx + 1].focus(); //  handles submit buttons
               inputs[idx + 1].select();
           }
           return false;
       }
        //console.log(promedio.toFixed(2)); 
    }

<?php } ?>

    function aplicaratodos(periodo,total,tipo_calificacion)
    {  
         //declaras una variable y un array
         var i, ArrayText = new Array();
         
         // obtienes el valor del elemento vr1 
         text1 = document.getElementById('op-area-'+periodo).value;
         
         // actualizas cada text
         for(i=0; i<total; i++)
         {
            if(document.getElementById('promedioarea-'+ i +'-promedio_estudiante-' + periodo).readOnly != true)
            {
                ArrayText[i] = document.getElementById('promedioarea-'+ i +'-promedio_estudiante-' + periodo);    
                ArrayText[i].value=text1.toUpperCase();

                <?php if ($tipo_calificacion != 1){ ?>
                    promediar(i,tipo_calificacion);
                <?php }else{ ?> 
                    desempeno(i,ArrayText[i],periodo);   
                <?php } ?> 
            }
         }
    }

    function mayusculas(id,e) 
    {
        e.value = e.value.toUpperCase();
    }

    function desempeno(id,e,periodo) 
    {
        //i = document.getElementById(e).value
        //nota = i.toUpperCase();     
        //document.getElementById(e).value = nota;
        
        e.value = e.value.toUpperCase();

        $.ajax({
                url: '../desempeno/desempenocolor?calificacion=' + e.value +'&tipo_calificacion=' + <?= $tipo_calificacion ?>,
                success: function(color) {

                    $('#'+ id + '-' + periodo).css('background-color', color);
                    console.log(color);
                    console.log("fila: " + id + '-' + periodo);
                },
                error: function() {
                    console.log("No se ha podido obtener la información de la fila" + id-1);
                }
            });
        
        $('#'+ id + '-' + periodo).text(e.value);


        <?php if ($tipo_calificacion != 1){ ?>
            $('#'+ id + '-' + periodo).text(promedio.toFixed(1));
            //console.log(promedio.toFixed(2)); 
        <?php } ?>   
        
    }


    function validar(e) 
    {
        i = document.getElementById(e).value
        nota = i.toUpperCase()
                .toString().replace(".", ",")
                .toString().replace("-", ",")
                .toString().replace("_", ",")
                .toString().replace("+", ",")
                .toString().replace(";", ",")
                .toString().replace(":", ",")
                .toString().replace("ç", ",")
                .toString().replace("}", ",");     

        document.getElementById(e).value = nota;

    } 

</script>
    

<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="demo-btn-group">
            <div class="callout callout-success">
                <div class="row"> 
                    <div class="col-sm-12">
                        <h4>
                            <?
                                $docente = Carga::find()->where(['asignatura' => Yii::$app->request->get('asignatura'), 'grupo' => Yii::$app->request->get('grupo')])->one(); 

                                //echo (isset($docente)) ? $docente->docentes->nombre : 'Sin Docente Asignado';
                            ?>
                        </h4>
                    </div>
                </div>
                <div class="row"> 
                    <div class="col-sm-4">
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-chalkboard-teacher fa-lg text-warning"></i>
                            <? 
                                $area = Area::findOne(Yii::$app->request->get('area'));
                                echo $area->area.' <small class="text-success">Área</small>';
                            ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-users fa-lg text-primary"></i>
                            <?= "Grupo ".$grupo->grupo; ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-clock fa-lg text-danger"></i>
                            <?
                                foreach ($periodos as $p)
                                    if($p->autorizar_calificaciones == '1')
                                        echo "<span class='label label-danger' data-toggle='tooltip' title = 'Periodo ".$p->id."' >P ".$p->id."</span>&nbsp;";
                            ?>
                            

                        </h5>
                    </div>
                    <div class="col-sm-4">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-pencil fa-lg text-success"></i>
                            <?= ($grupo->grados->calificacionxcompetencia == 1) ? '<span class="label label-primary">Calificación por Asignatura</span>' : '<span class="label label-success">Calificación por Competencia</span>'; ?>    
                            &nbsp; 
                            <?= '<span class="label label-warning">Tipo de Calificación '.$grupo->grados->tipoCalificaciones->tipo.'</span>'; ?>
                        </h5>
                    </div>
                </div>    
            </div>
        </div>
    </div>
</div>

   

    <? 
        $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                        ]
        ]);
    ?>

    <div class="row"> 
        <div class="col-sm-12"> 

            <div class="alert alert-info alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?  
                    echo '<h5 style="display:inline-block;">'.Yii::t('app', 'Tipo de Calificación').' <span class="label label-info">'.$grupo->grados->tipoCalificaciones->tipo.'</span></h5>';

                    $desempenos = Desempeno::find()->where(['tipo_calificacion' => $grupo->grados->tipo_calificacion])->all();
                    foreach ($desempenos as $desempeno) {
                        $rango = ($desempeno->limite_inferior != '') ? ' ('.$desempeno->limite_inferior : '';
                        $rango .= ($desempeno->limite_superior != '') ? ' a '.$desempeno->limite_superior.')' : '';    
                        echo '<div style="display:inline-block;"><span class="label" data-toggle="tooltip" title="'.$desempeno->desempeno.''.$rango.'" style="width:50px; background-color:'.$desempeno->color.'; color:#fff; margin:0 2px 0 10px;">'.$desempeno->nota.'</span> <b>'.$desempeno->desempeno.'</b><small> '.$rango.'</small></div>';
                    }
                ?>
            </div>
        </div>
    </div>

    <div class="row"> 
        <div class="col-sm-12">     
            <?= $form->errorSummary($calificaciones); ?>
        </div>
    </div>

<?php if($dataProvider->getTotalCount()!= 0) { ?>

    <div class="row"> 
        <div class="col-sm-12">     
            <div class="table-responsive">    
              <table class="table table-hover table-striped">
                <thead>

                    
                  <tr>
                    <th rowspan="2">#</th>
                    <th rowspan="2" style="min-width:300px"><?= Yii::t('app', 'Estudiante') ?></th>
                    <?
                            
                        
                        foreach ($periodos as $p)
                        {   
                            echo '<th colspan="2">';  

                            echo Html::tag('span',Yii::t('app', 'P').$p->id, ['class' => 'btn btn-block btn-danger', 'data-toggle' => 'tooltip', 'title' => '']);

                            echo '</th>';  
                        }
                        
                    ?>        
                    
                  </tr>
                  
                  <tr>
                    <?
                        foreach ($periodos as $p) 
                        {   
                            echo '<th colspan="2">';
                            
                            if($p->autorizar_calificaciones == '1') 
                            {
                                echo $this->render('_seleccionmultiplearea', [
                                        'model' => $seleccionmultiple, 
                                        'periodo' => $p->id, 
                                        'total_estudiantes' => $dataProvider->getTotalCount(),
                                        'tipo_calificacion' => $tipo_calificacion,
                                        'grado' => $grado,
                                        'area' => $area,
                                    ]);
                            }
                            echo '</th>';
                        }
                    ?>       
                    
                  </tr>
                </thead>
                <tbody>

<?php } ?>

            <?= ListView::widget([
                'dataProvider' => $dataProvider,
                'options' => [
                    'tag' => 'div',
                    'class' => 'list-wrapper',
                    'id' => 'list-wrapper',
                ],
                'viewParams' => ['calificaciones' => $calificaciones, 
                                    'registros' => $registros,
                                    'form' => $form, 
                                    'periodo' => $periodo,
                                    'periodos' => $periodos, 
                                    'tipo_calificacion' => $tipo_calificacion,
                                    'entrada' => $entrada,
                                    'grupo' => $grupo,
                                    'grado' => $grado,
                                    'area' => $area,
                                ],
                'itemView' => '_list_areas',
                'layout' => "{pager}\n{items}\n{summary}",
                'summary'=>'', 
            ]);
                
            ?>
           
<?php if($dataProvider->getTotalCount()!= 0) { ?> 
          
                </tbody>
            </table> 
    </div>

<?php } ?>

<? ActiveForm::end(); ?>



