<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ListView;
use yii\widgets\Pjax;
use kartik\widgets\ActiveForm;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Competencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Carga;

 
   
$this->title = 'Calificaciones';
$this->params['breadcrumbs'][] = ['label' => 'Panel del Docente', 'url' => ['docente/index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Guardar', 'url' => false, 'action' => 'guardar', 'icon' => '<i class="far fa-check"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Cancelar', 'url' => ['index'], 'icon' => '<i class="far fa-times"></i>', 'class' => 'danger'];

//echo "<br>calificacionxcompetencia: ".$calificacionxcompetencia;


$this->registerCss("
.table > thead > tr > td.salmon, 
.table > tbody > tr > td.salmon, 
.table > tfoot > tr > td.salmon, 
.table > thead > tr > th.salmon, 
.table > tbody > tr > th.salmon, 
.table > tfoot > tr > th.salmon, 
.table > thead > tr.salmon > td, 
.table > tbody > tr.salmon > td, 
.table > tfoot > tr.salmon > td, 
.table > thead > tr.salmon > th, 
.table > tbody > tr.salmon > th, 
.table > tfoot > tr.salmon > th {
    background-color: #D291BC;
}

.table-hover > tbody > tr > td.salmon:hover, 
.table-hover > tbody > tr > th.salmon:hover, 
.table-hover > tbody > tr.salmon:hover > td, 
.table-hover > tbody > tr:hover > .salmon, 
.table-hover > tbody > tr.salmon:hover > th 
{
    background-color: #C789B2;
}
.btn-salmon{
    color: #fff;
    background-color: #8D6B82;
    border-color: #87667C;
}



.table > thead > tr > td.purple, 
.table > tbody > tr > td.purple, 
.table > tfoot > tr > td.purple, 
.table > thead > tr > th.purple, 
.table > tbody > tr > th.purple, 
.table > tfoot > tr > th.purple, 
.table > thead > tr.purple > td, 
.table > tbody > tr.purple > td, 
.table > tfoot > tr.purple > td, 
.table > thead > tr.purple > th, 
.table > tbody > tr.purple > th, 
.table > tfoot > tr.purple > th {
    background-color: #E8C2ED;
}

.table-hover > tbody > tr > td.purple:hover, 
.table-hover > tbody > tr > th.purple:hover, 
.table-hover > tbody > tr.purple:hover > td, 
.table-hover > tbody > tr:hover > .purple, 
.table-hover > tbody > tr.purple:hover > th 
{
    background-color: #E0BBE4;
}
.btn-purple{
    color: #fff;
    background-color: #92278F;
    border-color: #81227E;
}

");

?>

<script type="text/javascript">         

<?php if ($tipo_calificacion != 1){ ?>


    function promediar(id,tipo) 
    { 
        var i;
        var promedio;
        var suma_saber = 0;
        var suma_ser = 0;
        var suma_psi = 0;
        var promedio_saber = 0;
        var promedio_ser = 0;
        var promedio_psi = 0;

        //alert("Promediar: "+id+tipo);

        for (i = 1; i <= <?= $num_calificaciones_saber ?>; i++) {
            suma_saber = suma_saber + Number(document.getElementById("calificacion-" + id + "-saber-" + i).value);
            console.log('Saber id: ' + id + ' i: ' + i + 'Suma: ' + suma_saber); 
        }

        promedio_saber = Number(((suma_saber / <?= $num_calificaciones_saber ?> ) * <?= $por_calificaciones_saber ?>) / 100); 

        console.log('Promedio Saber: ' + promedio_saber); 

<?php if ($num_calificaciones_ser != 0){ ?>

        for (i = 1; i <= <?= $num_calificaciones_ser ?>; i++) {
            suma_ser = suma_ser + Number(document.getElementById("calificacion-" + id + "-ser-" + i).value);
            console.log('Ser id: ' + id + ' i: ' + i + 'Suma: ' + suma_ser); 
        }

        promedio_ser = Number(((suma_ser / <?= $num_calificaciones_ser ?> ) * <?= $por_calificaciones_ser ?>) / 100); 

<?php } ?>

<?php if ($psi == 1){ ?>
        
        for (i = 1; i <= <?= $num_calificaciones_psi ?>; i++) {
            suma_psi = suma_psi + Number(document.getElementById("calificacion-" + id + "-psi-" + i).value);
            console.log('Psi id: ' + id + ' i: ' + i); 
        }

        promedio_psi = Number(((suma_psi / <?= $num_calificaciones_psi ?> ) * <?= $por_calificaciones_psi ?>) / 100); 

<?php } ?>
        
        promedio = promedio_saber + promedio_ser + promedio_psi; 

        $.ajax({
                url: '../desempeno/desempenocolor?calificacion=' + promedio +'&tipo_calificacion=' + tipo,
                success: function(color) {

                    $('#'+id).css('background-color', color);
                    console.log(color);
                },
                error: function() {
                    console.log("No se ha podido obtener la información de la fila" + id-1);
                }
            });
        
        $('#'+id).text(promedio.toFixed(1));


/*
        if (e.keyCode == 13) {
           var inputs = $(this).parents('form').eq(0).find(':input');
           var idx = inputs.index(this);

           if (idx == inputs.length - 1) {
               inputs[0].select()
           } else {
               inputs[idx + 1].focus(); //  handles submit buttons
               inputs[idx + 1].select();
           }
           return false;
       }
*/
        console.log(promedio.toFixed(2)); 
    }

<?php } ?>

    function aplicaratodos(id,tipo,total,tipo_calificacion,calificacionxcompetencia)
      {  

         //declaras una variable y un array
         var i,ArrayText = new Array();
         // obtienes el valor del elemento vr1 
         text1 = document.getElementById('op-'+tipo+'-'+id).value;
         
         // actualizas cada text
         for(i=0; i<total; i++)
         {
            if(calificacionxcompetencia == 1)
            {
                ArrayText[i] = document.getElementById('calificacion-'+ i +'-'+ tipo);
                //ArrayText[i] = document.getElementById('calificacion-'+ i +'-'+ tipo +'-'+id);
            }
            else
            {
                //ArrayText[i] = document.getElementById('calificacion-'+ i +'-'+ tipo +'-'+id);    
                ArrayText[i] = document.getElementById('calificacion-'+ i +'-'+ tipo);    
            }

            ArrayText[i].value=text1.toUpperCase();
            
            <?php if ($tipo_calificacion != 1){ ?>
                promediar(i,tipo_calificacion);
            <?php }else{ ?> 
                desempeno(i,ArrayText[i]);   
            <?php } ?> 
         }
      }

    function mayusculas(id,e) 
    {
        e.value = e.value.toUpperCase();
    }

    function desempeno(id,e) 
    {
        //i = document.getElementById(e).value
        //nota = i.toUpperCase();     
        //document.getElementById(e).value = nota;

        e.value = e.value.toUpperCase();

        //alert(e.value);

        $.ajax({
                url: '../desempeno/desempenocolor?calificacion=' + e.value +'&tipo_calificacion=' + <?= $tipo_calificacion ?>,
                success: function(color) {

                    $('#'+id).css('background-color', color);
                    console.log(color);
                },
                error: function() {
                    console.log("No se ha podido obtener la información de la fila" + id-1);
                }
            });
        
        $('#'+id).text(e.value);


        <?php if ($tipo_calificacion != 1){ ?>
            $('#'+id).text(promedio.toFixed(1));
            //console.log(promedio.toFixed(2)); 
        <?php } ?>   
        
    }


    function validarObservaciones(e) 
    {
        i = document.getElementById(e).value
        datos = i.replace(/[^0-9,]/g, '');

        document.getElementById(e).value = datos;

    } 


    function AddObservaciones(id, observacion) 
    {

    
        $('#calificacion-' + id + '-observacion_general').val( function( index, val ) {
            
            if(val == '')
            {
                return val + observacion;
            }
            else
            {
                return val + ',' + observacion;
            }
            
        });
        
        $('#add_'+observacion).html('<button type="button" id="add" class="btn btn-danger btn-xs" title="Eliminar" onclick="RemoveObservaciones('+ id +','+ observacion +');"><i class="fa fa-trash-alt" aria-hidden="true"></i></button>');


    }


    function RemoveObservaciones(id, observacion) 
    {

    
        $('#calificacion-' + id + '-observacion_general').val( function( index, val ) {
            
            return val.replace(',' + observacion, '');
        });
        
        $('#add_'+observacion).html('<button type="button" id="add" class="btn btn-primary btn-xs" title="Agregar" onclick="AddObservaciones('+ id +','+ observacion +');"><i class="fa fa-plus" aria-hidden="true"></i></button>');

    }
    
    $('input[name=ids]').val(function(index, value) {
       return value.replace('54,', '');
    });

</script>
    

<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="demo-btn-group">
            <div class="callout callout-success">
                <div class="row"> 
                    <div class="col-sm-12">
                        <h4>
                            <?
                                $docente = Carga::find()->where(['asignatura' => Yii::$app->request->get('asignatura'), 'grupo' => Yii::$app->request->get('grupo')])->andWhere(['eliminado_por' => 0])->one(); 

                                echo (isset($docente)) ? $docente->docentes->nombre : 'Sin Docente Asignado';
                            ?>
                        </h4>
                    </div>
                </div>
                <div class="row"> 
                    <div class="col-sm-4">
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-chalkboard-teacher fa-lg text-warning"></i>
                            <? 
                                $asignatura = Asignatura::findOne(Yii::$app->request->get('asignatura'));
                                echo $asignatura->asignatura.' <small class="text-success">'.$asignatura->especialidades->especialidad.'</small>';
                            ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-users fa-lg text-primary"></i>
                            <?= Yii::t('app', 'Grupo').' '.$docente->grupos->grupo; ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-clock fa-lg text-danger"></i>
                            <?= Yii::t('app', 'Periodo').' '.$periodo->id; ?>
                        </h5>
                    </div>
                    <div class="col-sm-4">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-pencil fa-lg text-success"></i>
                            <?= ($grupo->grados->calificacionxcompetencia == 1) ? '<span class="label label-primary">Calificación por Asignatura</span>' : '<span class="label label-success">Calificación por Competencia</span>'; ?>    
                            &nbsp; 
                            <?= '<span class="label label-warning">Tipo de Calificación '.$grupo->grados->tipoCalificaciones->tipo.'</span>'; ?>
                        </h5>
                    </div>
                </div>    
            </div>
        </div>
    </div>
</div>
<br>
<?php 
    
    //if ($calificacionxcompetencia == '2' && $periodo->actual->id != 5)
    if ($periodo->id != 5)
    {    
        
        if($num_competencias == 0 or $num_competencias == NULL or $num_competencias == '')
        {
?>

            <div class="row"> 
                <div class="col-sm-12"> 

                    <div class="alert alert-danger alert-dismissable">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <?  
                            echo '<b>No hay competencias cargadas en la asignatura</b>, debes cargar las competencias primero para poder realizar el cargue de las calificaciones. ';
                            echo Html::a('<i class="far fa-plus" aria-hidden="true"></i> Agregar Competencias', ['competencia/create', 'grado' => $grupo->grados->id, 'asignatura' => Yii::$app->request->get('asignatura')],['class' => 'btn btn-xs btn-primary']);
                        ?>
                    </div>
                </div>
            </div>
<?php
        }
        else
        {    
            
            $x=1; 
       
?>        
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="alert alert-info alert-dismissable">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <?  
                            echo '<b>Competencias</b><br><ul>';

                            foreach ($competencias as $competencia) {
                                echo '<li>'.$x.' <i class="fas fa-caret-right"></i>&nbsp;&nbsp;'.$competencia->competencia.'</li>';
                                $x++;
                            }

                        ?>
                        </ul>
                    </div>        
                </div>
            </div>

<?
            
        }    
    }
?>    


  
    <? 

    $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'enableAjaxValidation' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                        ]
        ]);
    ?>  
    
    <div class="row"> 
        <div class="col-sm-12"> 

            <div class="alert alert-info alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?  
                    echo '<b>Niveles de Desempeño</b> ';

                    $desempenos = Desempeno::find()->where(['tipo_calificacion' => $grupo->grados->tipo_calificacion])->all();
                    foreach ($desempenos as $desempeno) {
                        $rango = ($desempeno->limite_inferior != '') ? ' ('.$desempeno->limite_inferior : '';
                        $rango .= ($desempeno->limite_superior != '') ? ' a '.$desempeno->limite_superior.')' : '';    
                        echo '<span class="label" data-toggle="tooltip" title="'.$desempeno->desempeno.''.$rango.'" style="width:50px; background-color:'.$desempeno->color.'; color:#fff; margin:0 2px 0 10px;">'.$desempeno->nota.'</span> <b>'.$desempeno->desempeno.'</b><small> '.$rango.'</small>';
                    }
                ?>
            </div>
        </div>
    </div>

    <div class="row"> 
        <div class="col-sm-12">     
            <?= $form->errorSummary($calificaciones); ?>
        </div>
    </div>

<?php if($dataProvider->getTotalCount()!= 0) { ?>

    <div class="row"> 
        <div class="col-sm-12">     
            <div class="table-responsive">    
              <table class="table table-hover table-striped">
                <thead>

                    
                  <tr>
                    <th rowspan="2"></th>
                    <th rowspan="2" style="min-width:300px">Estudiante</th>

                    <?php

                        if($periodo->id == 5)
                        {
                            echo '<th colspan="4" style="max-width:40px">Histórico</th>';
                        }
                    ?>
                       
                    <?php 
                        
                        $sum = $num_calificaciones_ser + 3;

                        //if(($calificacionxcompetencia == '1') && ($periodo->id != '5'))
                        if($calificacionxcompetencia == '1')                            
                        {
                            echo '<th colspan="1">';
                            echo Html::tag('span','<i class="fas fa-info-circle"></i> '.((Yii::$app->request->get('periodo') == '5') ? 'Definitiva del Año' : 'Nota'), ['class' => 'btn btn-block btn-info', 'data-toggle' => 'tooltip', 'title' => (Yii::$app->request->get('periodo') == '5') ? 'Definitiva del Año' : $competencia->competencia]);
                            echo '</th>';
                        }
                        else
                        {
                            ////  NOTAS DE LAS COMPETENCIAS
                            $x = 1; 
                            foreach ($competencias as $competencia) {
                            
                                echo '<th colspan="1">';
                                    
                                echo Html::tag('span','<i class="fas fa-info-circle"></i> Nota '.$x, ['class' => 'btn btn-block btn-info', 'data-toggle' => 'tooltip', 'title' => $competencia->competencia]);

                                echo '</th>';
                                $x++;
                            }
                        }
                            
                        ////  PSI ACTIVO EN SEDES
                        if($psi == 1) 
                        {
                            echo '<th colspan="'.$num_calificaciones_psi.'">';
                            echo Html::tag('span','<i class="fas fa-info-circle"></i> PSI', ['class' => 'btn btn-block btn-purple', 'data-toggle' => 'tooltip', 'title' => 'Fallas Manuales']);
                            echo '</th>';
                        }

                        if($num_calificaciones_ser > 0) 
                        {
                            echo '<th colspan="'.$num_calificaciones_ser.'">';
                            echo Html::tag('span','<i class="fas fa-info-circle"></i> Ser ', ['class' => 'btn btn-block btn-success', 'data-toggle' => 'tooltip', 'title' => 'Calificaciones del Ser']);
                            echo '</th>';
                        }

                        if($num_calificaciones_ser > 0 or $psi == 1)
                        {
                            echo '<th>';
                            echo Html::tag('span','<i class="fas fa-info-circle"></i> Definitiva ', ['class' => 'btn btn-block btn-purple', 'data-toggle' => 'tooltip', 'title' => 'Definitiva del Periodo']);
                            echo '</th>';
                        } 
                        
                        /////////////   PROMEDIO  ///////////////////////////

                        if($tipo_calificacion=='1')
                        {
                            echo '<th rowspan="2" style="min-width:80px; vertical-align: middle; text-align: center;">';
                            
                            if($periodo->id == 5)
                            {
                                echo Html::tag('span','<i class="fas fa-info-circle"></i> Definitiva ', ['class' => 'btn btn-block btn-info', 'data-toggle' => 'tooltip', 'title' => 'Calificación definitiva de todos los periodos']);
                            }
                            else
                            {
                                echo Html::tag('span', '<i class="fas fa-info-circle"></i>', ['title' => 'Definitiva del Periodo', 'data-toggle' => 'tooltip', 'class' => 'text-info']);  
                            }
                            
                            echo '</th>';
                        }
                        
                        if($tipo_calificacion=='2')
                        {
                            echo '<th rowspan="2" style="min-width:80px; vertical-align: middle; text-align: center;">';
                            
                            if($periodo->id == 5)
                            {
                                echo Html::tag('span','<i class="fas fa-info-circle"></i> Definitiva ', ['class' => 'btn btn-block btn-info', 'data-toggle' => 'tooltip', 'title' => 'Calificación definitiva de todos los periodos']);
                            }
                            else
                            {
                                echo Html::tag('span', '<i class="fas fa-info-circle"></i>', ['title' => 'Definitiva del Periodo', 'data-toggle' => 'tooltip', 'class' => 'text-info']);  
                            }
                            
                            echo '</th>';
                        }

                        ////  FRD DE LAS COMPETENCIAS
                        if($frd == 0)
                        {
                            $x = 1; 
                            foreach ($competencias as $competencia) {


                                
                                $ancho = ($entrada == "1") ? "200px;" : "80px;";

                                echo '<th colspan="1"  style="min-width: '.$ancho.'">';
                                    
                                echo Html::tag('span','<i class="fas fa-info-circle"></i> FRD '.$x, ['class' => 'btn btn-block btn-salmon', 'data-toggle' => 'tooltip', 'title' => $competencia->competencia]);

                                echo '</th>';
                                $x++;
                            }
                        }  

                    ?>  
                    
                    <?php 
                        
                        if($periodo->id != 5) { 

                         if(($observacion_general == 1) OR ($observacion_especifica == 1)) {

                            $total_columnas = $observacion_general + $observacion_especifica;

                    ?>

                        <th colspan="<?= $total_columnas ?>">
                            <? Html::tag('span','<i class="fas fa-info-circle"></i> Observaciones ', ['class' => 'btn btn-block btn-warning', 'data-toggle' => 'tooltip', 'title' => 'Observaciones Generales y Específicas']); ?>
                            <?= Html::button('<i class="fas fa-info-circle"></i> Observaciones', ['value' => Url::to(['obsgeneral/listar']), 'title' => 'Observaciones Generales', 'class' => 'showModalButton btn btn-block btn-warning']);  ?>
                        </th> 

                    <?php }} ?>

                    <?php if($fallas == 0 && $periodo->id != 5) { ?>                            
                           
                        <th colspan="2">
                            <?= Html::tag('span','<i class="fas fa-info-circle"></i> Fallas', ['class' => 'btn btn-block btn-danger', 'data-toggle' => 'tooltip', 'title' => 'Fallas Manuales']); ?>
                        </th>
                        
                    <?php } ?>

                    </tr>



<!--  //////////////////  SEGUNDA FILA DE LAS OPCIONES   ///////////////////    -->


                    <tr>

                    <?php 
                        if($periodo->id == 5)
                        {
                            /////// HISTORICO DE PERIODOS
                            
                            for($i=1;$i<=4;$i++) 
                            {
                                echo "<th style='max-width:10px'>P".$i."</th>"; 
                            }
                        }
                    ?> 
                    
                    <?php 
                        
                        if($calificacionxcompetencia == '1')
                        {
                            echo "<th style='min-width:80px'>";
                            echo $this->render('_seleccionmultiple', ['model' => $seleccionmultiple, 'i' => '1', 'num_calificaciones' => $num_calificaciones_saber, 'tipo' => 'saber', 'total_estudiantes' => $dataProvider->getTotalCount(),'tipo_calificacion' => $tipo_calificacion, 'calificacionxcompetencia' => $calificacionxcompetencia]);
                            echo "</th>"; 
                        }
                        else
                        {
                            $i = 1;
                            foreach ($competencias as $competencia) 
                            { 
                                echo "<th style='min-width:80px'>2";
                                echo $this->render('_seleccionmultiple', ['model' => $seleccionmultiple, 'i' => $i, 'num_calificaciones' => $num_calificaciones_saber, 'tipo' => 'saber', 'total_estudiantes' => $dataProvider->getTotalCount(),'tipo_calificacion' => $tipo_calificacion, 'calificacionxcompetencia' => $calificacionxcompetencia]);
                                echo "</th>"; 
                                $i++; 
                            }
                        } 
                    ?> 
                    
                     <?php 
                        if($psi == 1)
                        {
                            /////// SELECT DEL PSI 
                            
                            for($i=1;$i<=$num_calificaciones_psi;$i++) 
                            {
                                echo "<th style='min-width:80px'>";
                                echo $this->render('_seleccionmultiple', ['model' => $seleccionmultiple, 'i' => $i, 'num_calificaciones' => $num_calificaciones_ser, 'tipo' => 'psi', 'total_estudiantes' => $dataProvider->getTotalCount(),'tipo_calificacion' => $tipo_calificacion, 'calificacionxcompetencia' => $calificacionxcompetencia]);
                                echo "</th>"; 
                            }
                        }
                    ?> 

                    <?php 
                        /////// SELECT DEL SER 
                        
                        for($i=1;$i<=$num_calificaciones_ser;$i++) 
                        { 
                            echo "<th style='min-width:80px'>";
                            echo $this->render('_seleccionmultiple', ['model' => $seleccionmultiple, 'i' => $i, 'num_calificaciones' => $num_calificaciones_ser, 'tipo' => 'ser', 'total_estudiantes' => $dataProvider->getTotalCount(),'tipo_calificacion' => $tipo_calificacion, 'calificacionxcompetencia' => $calificacionxcompetencia]);
                            echo "</th>"; 
                        } 
                    ?> 

                    <?php 
                        
                        if($frd == 0)
                        {
                            foreach ($competencias as $competencia) 
                            {
                            
                        
                    ?>   
                        
                        <th style="min-width:80px; vertical-align: middle; text-align: center;">FRD
                            <?= Html::a('<i class="fas fa-info-circle"></i>', false, ['value' => Url::to(['frd/listar', 'competencia' => $competencia->id]), 'title' => 'Fortalezas, Recomendaciones y Debilidades', 'class' => 'showModalButton text-info']); ?>
                        </th>
                    
                    <?php }} ?>

                    <?php if($periodo->id != 5) { 

                        if($observacion_general == 1) {
                    ?>

    
                        <th style="min-width:<?= $entrada == '1' ? '200px;' : '80px;' ?> vertical-align: middle; text-align: center;">
                            General
                            <?= Html::a('<i class="fas fa-info-circle"></i>', false, ['value' => Url::to(['obsgeneral/listar']), 'title' => 'Observaciones Generales', 'class' => 'showModalButton text-info']); ?>
                        </th>
                    
                    <?php  } if($observacion_especifica == 1) {
                    ?>
                        <th style="min-width:120px; vertical-align: middle; text-align: center;">Específica</th>
                    
                    <?php }} ?>    

                        <?php
                            if($fallas == 0 && $periodo->id != 5)
                            {
                                echo "<th style='min-width:80px; vertical-align: middle; text-align: center;'>Fallas</th>";
                            } 
                        ?>
                        

                  </tr>
                </thead>
                <tbody>

<?php } ?>

            <?= ListView::widget([
                'dataProvider' => $dataProvider,
                'options' => [
                    'tag' => 'div',
                    'class' => 'list-wrapper',
                    'id' => 'list-wrapper',
                ],
                'viewParams' => [
                                    'calificaciones' => $calificaciones, 
                                    'registros' => $registros,
                                    'form' => $form, 
                                    'psi' => $psi,
                                    'periodo' => $periodo->id, 
                                    'competencias' => $competencias,
                                    'tipo_calificacion' => $tipo_calificacion,
                                    'entrada' => $entrada,
                                    'fallas' => $fallas,
                                    'frd' => $frd,
                                    'calificacionxcompetencia' => $calificacionxcompetencia,
                                    'num_competencias' => $num_competencias,
                                    'num_calificaciones_saber' => $num_calificaciones_saber,
                                    'num_calificaciones_ser' => $num_calificaciones_ser,   
                                    'por_calificaciones_saber' => $por_calificaciones_saber,
                                    'por_calificaciones_ser' => $por_calificaciones_ser,
                                    'num_calificaciones_psi' => $num_calificaciones_psi,
                                    'por_calificaciones_psi' => $por_calificaciones_psi,
                                    'observacion_general' => $observacion_general,
                                    'observacion_especifica' => $observacion_especifica,
                                ],
                'itemView' => '_list_calificaciones',
                'layout' => "{pager}\n{items}\n{summary}",
                'summary'=>'', 
            ]);
                
            ?>

<?php if($dataProvider->getTotalCount()!= 0) { ?>

                </tbody>
            </table> 
    </div>


<?php } ?>
<? ActiveForm::end(); ?>



