<?php


use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\Select2;
use yii\db\Expression;

use backend\models\Tercero;

$this->title = 'Lanzador Docente';
$this->params['breadcrumbs'][] = ['label' => 'Reportes', 'url' => ['index']];
$this->params['breadcrumbs'][] = 'Buscar Reporte';


?>
   <?php $form = ActiveForm::begin([
      'type' => ActiveForm::TYPE_VERTICAL,
      'options' => ['class' => 'main-task-form',
                    'id' => 'formulario',
                  ]
  ]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Lanzador Docente</h3>
    </div>

    <div class="panel-body">

      <div class="row">

        <div class="col-sm-3 hidden-xs">
            <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs']); ?>
        </div>    
    

        <div class="col-sm-9">

                <?= $form->field($model, 'primer_nombre')->widget(Select2::classname(), [
                    'data' => ArrayHelper::map(Tercero::find()->select(['tercero.id', new Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->leftjoin('academico', 'academico.estudiante = tercero.id')->Where(['tercero.tipo_tercero' => '1'])->andWhere(['<', 'tercero.estado', '3'])->orderBy('tercero.primer_apellido')->asArray()->all(), 'id', 'nombre'),
                    'options' => ['placeholder' => 'Seleccione el Estudiante'],
                    'hideSearch' => false,
                    'pluginOptions' => [
                        'allowClear' => true,

                    ],
                    'addon' => [
                                  //'prepend' => ['content'=>'<i class="fas fa-search"></i>'],
                                  'append' => ['content' => Html::submitButton('<i class="fa fa-search" aria-hidden="true"></i>', ['id' => 'addbutton', 'title' => Yii::t('app', 'Cargar Calificaciones'), 'class' => 'btn btn-primary', 'disabled' => false]), 'asButton' => true,]
                               ],
                ])->label(false);
                
              ?>
        </div>
      </div>
    </div>        
</div>

    <?php ActiveForm::end(); ?>
