<?php


use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\DepDrop;
use kartik\daterange\DateRangePicker;



$this->registerJs("

$('#tipo-id').change(function(){
    
    if(this.value == '1' || this.value == '2' || this.value == '3')
    {
        $('#grupo').fadeOut(0);
        $('#grado').fadeOut(0);
    }

    if(this.value == '4')
    {
        $('#grupo').fadeOut(0);
        $('#grado').fadeIn(500);
    }
    
    if(this.value == '5')
    {
        $('#grado').fadeOut(0);
        $('#grupo').fadeIn(500);
    }    
        
        $('#niveles').html('');

    });


     
");

?>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Proceso Electoral</h3>
    </div>

    <div class="panel-body" >

        <?php
            $form = ActiveForm::begin([
                'validateOnSubmit' => true,
                'type' => ActiveForm::TYPE_VERTICAL,
                'options' => ['class' => 'main-task-form',
                              'id' => 'formulario',
                              'enctype'=>'multipart/form-data',
                            ]
            ]); 
        ?>

            <?= $form->errorSummary($model); ?>


            <? $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

        
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6">
                <?= $form->field($model, 'campana')->textInput(['maxlength' => true, 'placeholder' => 'Campana']) ?>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6">
                <?= $form->field($model, 'tipo')->widget(\kartik\widgets\Select2::classname(), [
                    'data' => \yii\helpers\ArrayHelper::map(\backend\models\Campanatipo::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                    'options' => ['id'=>'tipo-id','placeholder' => Yii::t('app', 'Seleccione Tipo de Campaña')],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div id="grado" class="col-sm-12" style="display:none">
                <?= $form->field($model, 'grado[]')->widget(\kartik\widgets\Select2::classname(), [
                    'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->orderBy('id')->asArray()->all(), 'id', 'grado'),
                    'options' => ['id'=>'grado-id','placeholder' => Yii::t('app', 'Seleccione el Grado')],
                    'pluginOptions' => [
                        'allowClear' => true,
                        'multiple' => true,
                    ],
                ]); ?>
            </div>
            <div id="grupo" class="col-sm-12" style="display:none">
                <?= $form->field($model, 'grupo[]')->widget(\kartik\widgets\Select2::classname(), [
                    'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->orderBy('id')->asArray()->all(), 'id', 'grupo'),
                    'options' => ['id'=>'grupo-id','placeholder' => Yii::t('app', 'Seleccione el Grupo')],
                    'pluginOptions' => [
                        'allowClear' => true,
                        'multiple' => true,
                    ],
                ]); ?>
            </div>
        </div>

        <div class="row">

                    <div class="col-sm-6">
                        <label>Proceso Electoral Desde y Hasta</label>    
            
                            <?php
                                $addon = '<span class="input-group-addon">
                                            <i class="glyphicon glyphicon-calendar"></i>
                                        </span>';

                                echo '<div class="input-group drp-container">';

                                if ($model->isNewRecord)
                                {
                                    date_default_timezone_set('America/Bogota');    
                                    $model->fecha_inicio = date('Y-m-d H:i:s', strtotime( 'monday this week' ) );
                                    $model->fecha_fin = date('Y-m-d H:i:s', strtotime( 'friday this week' ) );

                                    $model->rango = $model->fecha_inicio." - ".$model->fecha_fin;
                                }    

                                
                                echo DateRangePicker::widget([
                                    'model'=>$model,
                                    'attribute' => 'rango',
                                    'useWithAddon'=>true,
                                    'autoUpdateOnInit'=>true,
                                    'convertFormat'=>true,
                                    'presetDropdown' => false,
                                    'startAttribute' => 'fecha_inicio',
                                    'endAttribute' => 'fecha_fin',
                                    'pluginOptions'=>[
                                        'timePicker' => true,
                                        'locale'=>[
                                            'format' => 'Y-m-d H:i:s',
                                            'separator'=> ' al ',
                                        ],                                        
                                    ]
                                ]) . $addon;
                                echo '</div>';
                            ?>
                    </div>



            <div class="col-sm-3">
                <? $model->estado = $model->isNewRecord ? 1 : $model->estado; ?>

                <?= $form->field($model, 'estado')->widget(SwitchInput::classname(), ['pluginOptions' => [
                    'size' => 'medium',
                    'onColor' => 'success',
                    'offColor' => 'danger',
                    'onText'=>'Activo',
                    'offText'=>'Inactivo'
                ]]) 
                ?>
            </div>
        </div>
        
        <?php ActiveForm::end(); ?>
    </div>    
</div>
