<?php

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;

$this->title = Yii::t('app', 'Campaña');

$this->params['breadcrumbs'][] = $this->title;


$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Informe Consolidado', 'url' => 'pdf', 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$this->params['breadcrumbs'][] = $this->title;
$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);
?>

<script src="//www.gstatic.com/charts/loader.js"></script>

<div class="campana-index">

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'campana',
        [
                'attribute' => 'tipo',
                'label' => Yii::t('app', 'Tipo'),
                'value' => function($model){
                    if ($model->tipos)
                    {return $model->tipos->tipo;}
                    else
                    {return NULL;}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\CampanaTipo::find()->asArray()->all(), 'id', 'tipo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Campana tipo', 'id' => 'grid-campana-search-tipo']
            ],
        [
                'attribute' => 'grado',
                'label' => Yii::t('app', 'Grado'),
                'value' => function($model){
                    if ($model->grados)
                    {return $model->grados->grado;}
                    else
                    {return NULL;}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->asArray()->all(), 'id', 'grado'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-campana-search-grado']
            ],
        [
                'attribute' => 'grupo',
                'label' => Yii::t('app', 'Grupo'),
                'value' => function($model){
                    if ($model->grupos)
                    {return $model->grupos->grupo;}
                    else
                    {return NULL;}
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->asArray()->all(), 'id', 'grupo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Grupo', 'id' => 'grid-campana-search-grupo']
            ],
        [
            'attribute' => 'fecha_inicio',
            'label' => Yii::t('app', 'Fecha de Inicio'),
            'value' => function($model){                   
                return Yii::$app->formatter->asDatetime($model->fecha_inicio, 'short');
            },
            'filterType' => GridView::FILTER_DATETIME,
                'filterWidgetOptions' => [
                    'pluginOptions' => ['format' => 'yyyy-mm-dd HH:ii', 'todayHighlight' => true, 'autoclose' => true,],
                ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-campana-search-fecha_inicio'],
            'visible' => false,

        
        ],
        [
            'attribute' => 'fecha_fin',
            'label' => Yii::t('app', 'Fecha de Finalización'),
            'value' => function($model){                   
                return Yii::$app->formatter->asDatetime($model->fecha_fin, 'short');
            },
            'filterType' => GridView::FILTER_DATETIME,
                'filterWidgetOptions' => [
                    'pluginOptions' => ['format' => 'yyyy-mm-dd HH:ii', 'todayHighlight' => true, 'autoclose' => true,],
                ],
            'filterInputOptions' => ['placeholder' => '', 'id' => 'grid-campana-search-fecha_fin'],
            'visible' => false,

        
        ],
        [   
            'attribute' => 'resumen',
            'width' => '120px',
            'label' => Yii::t('app', 'Resumen'),
            'format' => 'RAW',
            'value' => function($model)
            {


                return Html::button('<span title="'.Yii::t('app', 'Total Candidatos').'" data-toggle="tooltip"> <i class="fas fa-user"></i> '.count($model->items). '</span>', ['value' => Url::to(['votar','id' => $model->id]), 'title' => $model->campana, 'class' => 'showModalButton btn btn-xs btn-success'])
                       .'&nbsp;&nbsp;'. '<span title="'.Yii::t('app', 'Total Votos').'" data-toggle="tooltip">'. Html::button('<i class="fas fa-vote-yea"></i> '.count($model->votos), ['value' => Url::to(['votos','id' => $model->id]), 'title' => $model->campana, 'class' => 'showModalButton btn btn-xs btn-info']);
                ;

                /*return '<h4><span title="'.Yii::t('app', 'Total Candidatos').'" data-toggle="tooltip" class="label label-success"><i class="fas fa-user"></i> '.count($model->items).'</span>'
                       .'&nbsp;&nbsp;<span title="'.Yii::t('app', 'Total Votos').'" data-toggle="tooltip" class="label label-info"> <i class="fas fa-vote-yea"></i> '.count($model->votos).'</span></h4>';*/
            },
            
        ],
        [   
            'attribute' => 'agregar',
            'label' => Yii::t('app', 'Agregar'),
            'format' => 'RAW',
            'value' => function($model){
                return Html::button('<i class="fas fa-plus"></i> <span class="hidden-xs">'.Yii::t('app', 'Agregar Candidato').'</span>', ['value' => Url::to(['campanaitem/create','campana' => $model->id]), 'title' => $model->campana, 'class' => 'showModalButton btn btn-xs btn-success']);
            },
            
        ],
        [   
            'attribute' => 'agregar',
            'label' => Yii::t('app', 'Votación'),
            'format' => 'RAW',
            'value' => function($model){
                return Html::button('<i class="fas fa-plus"></i> <span class="hidden-xs">'.Yii::t('app', 'Ver Votación').'</span>', ['value' => Url::to(['votos','id' => $model->id]), 'title' => $model->campana, 'class' => 'showModalButton btn btn-xs btn-success']);
            },
            
        ],
        [
            'class'=>'kartik\grid\BooleanColumn',
            'attribute'=>'estado', 
            'vAlign'=>'middle'
        ],
        [
            'class'=>'kartik\grid\ActionColumn',
            'dropdown'=>false,
            'order'=>DynaGrid::ORDER_FIX_RIGHT,
        ],
        ['class'=>'kartik\grid\CheckboxColumn',  'order'=>DynaGrid::ORDER_FIX_RIGHT],
    ]; 
    ?>

    
<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'campanas'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
