<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Campana */

$this->title = $model->campana;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Campaña'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="campana-view">


    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'campana',
        [
            'attribute' => 'tipos.tipo',
            'label' => Yii::t('app', 'Tipo'),
        ],
        [
            'attribute' => 'grados.grado',
            'label' => Yii::t('app', 'Grado'),
        ],
        [
            'attribute' => 'grupos.grupo',
            'label' => Yii::t('app', 'Grupo'),
        ],
        'fecha_inicio',
        'fecha_fin',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>

    <div class="row">
<?php
if($providerCampanaItem->totalCount){
    $gridColumnCampanaItem = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
                        [
                'attribute' => 'item.terceros.nombres',
                'label' => Yii::t('app', 'Tercero')
            ],
            ['attribute' => 'mensaje', 'format' => 'raw'],
            ['attribute' => 'adjunto', 'visible' => false],
            [
                'attribute' => 'mensaje', 
                'format' => 'raw',
                'value' => function($model){
                    return $item->terceros->foto ? Html::img('@web/uploads/thumbnail/lg-'.$item->terceros->foto, ['class'=>'img-responsive']) : Html::img($item->terceros->foto ? '@web/uploads/thumbnail/sm-'.$item->terceros->foto : '@web/images/user.jpg', ['class'=>'img-responsive']);
                },
            ],

            
            ['attribute' => 'estado', 'visible' => false],
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCampanaItem,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-campana-item']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Candidatos')),
        ],
        'columns' => $gridColumnCampanaItem
    ]);
}
?>

    </div>
    
    <div class="row">
<?php
if($providerCampanaVoto->totalCount){
    $gridColumnCampanaVoto = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
                        [
                'attribute' => 'items.nombre',
                'label' => Yii::t('app', 'Item')
            ],
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCampanaVoto,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-campana-voto']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Campana Voto')),
        ],
        'columns' => $gridColumnCampanaVoto
    ]);
}
?>

    </div>
</div>
