<?php

use yii\helpers\Html;
use yii\helpers\Url;


$this->registerJs("

    function save(campana, item) 
    {
 
        $.ajax({
            type: 'POST',
            url: '". Url::to(['campanavoto/addsave'])."',
            timeout: 5000,

            data: {campana : campana, item : item},

            success: function (data) {
                //$('#info').html(\"<i class='fas fa-check text-success'></i>\");
                
                $('#staff').html(\"<center><h3><i class='fas fa-check text-success'></i> Gracias por su voto!</h3></center>\");

                $('#estandar-id').append($('<option>', {
                    value: data,
                    text: estandar,
                }));
                
                $('#estandar-id').val(data);

                $('#modal').modal('hide'); //ocultamos el modal
                $('body').removeClass('modal-open');    //eliminamos la clase del body para poder hacer scroll
                $('.modal-backdrop').remove();  //eliminamos el backdrop del modal
                    
                
            },
            error: function(request, status, err) {
                if (status == 'timeout') {
                    //timeout -> reload the page and try again
                    $('#info').html(\"<i class='fas fa-times text-danger'></i>\");
                    console.log('timeout');
                    //window.location.reload();
                } else {
                    $('#info').html(\"<span class='text-danger'>\"+ err + \"</span>\");
                    //another error occured  
                    //alert('error: ' + request + status + err);
                }
            }
    
        });
        
    }

");


$this->registerCss("

.staff-list {
  margin-bottom: 1rem;
  border: 1px solid #e1e4f4;
  background: #ffffff;
  -webkit-border-radius: 2px;
  -moz-border-radius: 2px;
  border-radius: 2px;
  display: block; }
  .staff-list:hover {
    color: inherit;
    border: 1px solid #ced3ed;
    box-shadow: 0 0 20px #e1e5f1; }
  .staff-list .staff-list-body {
    padding: 1rem;
    position: relative; }
  .staff-list .img-responsive {
    margin-bottom: 15px; }
  .staff-list .staff-title {
    font-size: 16px;
    margin-bottom: 10px;
    font-weight: 700; 
    color:#000000;
    }
      
  .staff-list .staff-designation {
    margin: 0 0 10px 0; }
    .staff-list .staff-designation span {
      color: #8796af; }
  .staff-list .staff-experience {
    margin: 0 0 10px 0; }
    .staff-list .staff-experience span {
      color: #8796af; }
  .staff-list .staff-field {
    margin: 0 0 10px 0;
    display: flex;
    align-items: center; }
    .staff-list .staff-field .badge {
      margin-left: 5px;
      -webkit-border-radius: 30px;
      -moz-border-radius: 30px;
      border-radius: 30px; }
  .staff-list p.staff-description {
    margin: 15px 0 0 0; }

");

?>

<div id="staff">

    <?php

      $x = 1;
      foreach ($model->items as $item) { 

        if($x == 1 or $x == 4 or $x == 7)
        {
            echo '<div class="row">';
        }

    ?>

        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-6 col-6">
            
            <!-- Staff list start -->
            <div class="staff-list">
                <div class="staff-list-body">
                    <!--<img src="img/user.png" class="img-fluid" alt="University Staff">-->
                    <?= $item->foto ? Html::img('@web/uploads/thumbnail/lg-'.$item->foto, ['class'=>'img-responsive']) : Html::img($item->terceros->foto ? '@web/uploads/thumbnail/sm-'.$item->tercero->foto : '@web/images/user.jpg', ['class'=>'img-responsive']); ?>
                    
                    <div class="staff-title"><?= $item->terceros->nombre ?></div>
                    <div class="staff-field">
                        <? 
                            if($model->tipo != 6) 
                            {
                                echo '<span class="badge badge-primary">'.$item->terceros->grupos->grupos->grupo.'</span>';
                            } 
                            else 
                            {
                                echo '<span class="badge badge-primary">'.$item->terceros->tipoterceros->tipo.'</span>';
                            } 
                        ?>
                    </div>
                    <div class="staff-designation">
                        <? 
                            //echo "Voto: ".$voto." tipo: ".Yii::$app->session->get('__tipo')." campana: ".$model->tipo."<br>";

                            if ((Yii::$app->session->get('__tipo') <= 2) OR ($model->tipo == 6))
                            { 
                                if($voto > 0)
                                {
                                    echo Html::Button('<i class="far fa-check"></i> Ya Has Votado!', ['type' => 'button', 'class' => 'btn btn-block btn-danger']);
                                }
                                else
                                {
                                    echo Html::Button('<i class="far fa-vote-yea"></i> Votar', ['type' => 'button', 'class' => 'btn btn-block btn-success', 'id' => 'aplicar', 'onClick' => 'save('.$item->campana.','.$item->id.')']);
                                }
                            }
                        ?>
                        
                    </div>
                    <p class="staff-description">
                        <?= $item->mensaje ?>
                    </p>

                    

                    <? 
                        if ($item->adjunto != '') 
                        {
                            //$adjuntos = explode(',', $item->adjunto); 
                            //$adjuntos_cantidad = count($adjuntos);

                            $adjunto = json_decode(json_encode($item->adjunto),true);
                            $largo = strlen($adjunto["ObjectURL"]) - 46;
                            $archivo = substr($adjunto["ObjectURL"], 46, $largo);
                            $ext = substr($adjunto["ObjectURL"], -4);

                    ?>

                    <div class="mail-attachment"><!-- INICIO ATTACH -->
                        <p>
                            <span><i class="far fa-paperclip"></i> <?= ' Archivo Adjunto'?></span>
                        </p>


                        <div class="attachment">
                            
                                

                                <!--<div class="file-box">
                                    <div class="file">
                                        
                                        
                                            <span class="corner"></span>-->

                                            <?
                                                
                                                    switch ($ext) {
                                                        
                                                        case '.jpg':
                                                                $icon = 'far fa-file-image text-danger';
                                                            break;

                                                        case '.png':
                                                                $icon = 'far fa-file-image text-danger';
                                                            break; 

                                                        case '.gif':
                                                                $icon = 'far fa-file-image text-danger';
                                                            break;       

                                                        case '.pdf':
                                                                $icon = 'far fa-file-pdf text-danger';
                                                            break;
                                                        case '.xls':
                                                                $icon = 'far fa-file-excel text-success';
                                                            break;
                                                        case 'xlsx':
                                                                $icon = 'far fa-file-excel text-success';
                                                            break;
                                                        case '.csv':
                                                                $icon = 'far fa-file-csv text-success';
                                                            break;       
                                                        case 'docx':
                                                                $icon = 'far fa-file-word text-primary';
                                                            break;
                                                        case '.doc':
                                                                $icon = 'far fa-file-word text-primary';
                                                            break;
                                                        case 'pptx':
                                                                $icon = 'far fa-file-powerpoint text-danger';
                                                            break;
                                                        case '.ppt':
                                                                $icon = 'far fa-file-powerpoint text-danger';
                                                            break;
                                                                
                                                        default:
                                                                $icon = 'far fa-file';
                                                            break;
                                                    }
                                                    //echo "<div class='icon'><i class='".$icon."'></i></div>";

                                                    echo Html::a('<i class="'.$icon.'"></i> Descargar', Url::to($adjunto["ObjectURL"]), ['data-pjax'=>0, 'target' => '_blank', 'class' => 'btn btn-danger', 'title'=> urldecode($archivo)]);

                                                    //echo "<div class='adjunto'>";
                                                    //echo Html::img('https://drive.google.com/thumbnail?id='.$archivo["id"], ['alt'=>$archivo["file"], 'class'=>'']);
                                                    //echo"</div>";
                                                     
                                                                                            

                                            ?>
                                            
                                   <!-- </div>

                                </div>-->
                            
                            <div class="clearfix"></div>
                        </div> 

                    </div><!-- FIN ATTACH -->

                    <?php 
                        
                        }
                        else
                        { 
                    ?>    
                                <div class="mail-attachment"><!-- INICIO ATTACH -->
                                    <p>
                                        <span><i class="far fa-paperclip"></i> Sin Archivos Adjuntos</span>
                                    </p>
                                </div>
                    <?php
                        } 
                     ?>  

                </div>
            </div>
            <!-- Staff list end -->

        </div>

    <?php 

          if($x == 3 or $x == 3 or $x == 9)
          {
              echo '</div>';
          }

          $x++;
      } 
    ?>

</div>