<?php
use sjaakp\gcharts\ColumnChart;
use backend\models\Grupo;
use yii\helpers\ArrayHelper;

    switch ($model->tipo) 
    {
        case '4':
          $grupo = $model->grados->grado;
          break;

        case '5':
          $grupo = $model->grupos->grupo;
          break;
      
        default:
        # code...
          break;
    }
?>


<?= \onmotion\apexcharts\ApexchartsWidget::widget([
        'type' => 'bar', // default area
        //'height' => '400', // default 350
        'width' => '100%', // default 100%
        'chartOptions' => [
            'title' => [
                'text' => 'Resultados '.$model->tipos->tipo.' '.$grupo,
                'align' => 'center',
                'margin' => 10,
                'offsetX' => 0,
                'offsetY' => 0,
                'floating' => false,
                'style' => [
                  'fontSize' =>  '16px',
                  'fontWeight' =>  'bold',
                  //'fontFamily' =>  'Arial',
                  'color' =>  '#4c66a4',
                ],
            ],
            'chart' => [
                'toolbar' => [
                    'show' => true,
                    'offsetX' => 0,
                    'offsetY' => 0,
                    'tools' => [
                      'download'  => true,
                      'selection' => true,
                      'zoom'  => true,
                      'zoomin'  => true,
                      'zoomout' => true,
                      'pan' => true,
                      'reset' => true,
                      'customIcons' => [],
                    ],
                    'autoSelected' => 'zoom',
                ],
                'selection' => [
                    'enabled' => true,
                ],
                'zoom' => true,
            ],
            'xaxis' => [
                //'type' => 'datetime',
                'categories' => ArrayHelper::getColumn($votos,'nombre'),
            ],
            'yaxis' => [
                'title' => [
                    'text' => 'Total de Votos'
                ]
            ],
            'plotOptions' => [
                'bar' => [
                    'horizontal' => false,
                    'columnWidth' => '50%',
                    'distributed' => true,
                    //'endingShape' => 'rounded'
                ],
            ],
            'dataLabels' => [
                'enabled' => true
            ],
            'stroke' => [
                'show' => true,
                //'width' => 2,
                'colors' => ['transparent']
            ],
            'legend' => [
                'verticalAlign' => 'bottom',
                'horizontalAlign' => 'left',
            ],
        ],
        'series' => [[
                'name' => 'Votos',
                'data' => ArrayHelper::getColumn($votos,'votos')
            ]],
    ]);
?>
