<?php


use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\DatePicker;
use kartik\widgets\Select2;
use kartik\widgets\FileInput;
use dosamigos\tinymce\TinyMce;

?>


        <?php
            $form = ActiveForm::begin([
                'validateOnSubmit' => true,
                'type' => ActiveForm::TYPE_VERTICAL,
                'options' => ['class' => 'main-task-form',
                              'id' => 'formulario',
                              'enctype'=>'multipart/form-data',
                            ]
            ]); 
        ?>

            <?= $form->errorSummary($model); ?>


            <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>
            <?= $form->field($model, 'campana', ['template' => '{input}'])->textInput(['style' => 'display:none']); ?>

    <div class="row">

        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 hidden-xs">
            <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'position:fixed; z-index:0;']); ?>
        </div>    


        <div class="col-lg-10 col-md-10 col-sm-12 col-xs-12">
            <div class="row">
                <div class="col-sm-12">

                    <?                         
                        switch ($campana->tipo) 
                        {
                            case '1':
                            // TESORERO
                                $terceros = $tercero->getEstudiantesxtesorero();
                                break;
                            case '2':
                            // PERSONERO
                                $terceros = $tercero->getEstudiantesxtesorero();
                                break;
                            case '3':
                            // CONTRALOR
                                $terceros = $tercero->getEstudiantesxtesorero();
                                break;
                            case '4':
                            // REPRESENTANTE DE GRADO
                                $terceros = $tercero->getEstudiantesxgrado($campana->grado);
                                break;
                            case '5':
                            // REPRESENTANTE DE GRUPO
                                $terceros = $tercero->getEstudiantesxgrupo($campana->grupo);
                                break;
                            case '6':
                            // CONCEJO DIRECTIVO
                                $terceros = $tercero->getDocentes();
                                break;
                            
                            default:
                                
                                break;
                        }
                    ?>

                    <?= $form->field($model, 'tercero')->widget(\kartik\widgets\Select2::classname(), [
                        //'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['estado' => '1', 'tipo_tercero' => '1'])->asArray()->all(), 'id', 'nombre'),
                        'data' => \yii\helpers\ArrayHelper::map($terceros, 'id', 'nombre'),
                        

                        'options' => ['id'=>'tercero-id','placeholder' => Yii::t('app', 'Seleccione Tercero')],
                        'pluginOptions' => [
                            'allowClear' => true,
                            'tags' => true,
                        ],
                    ]); ?>

                </div>
            </div>

            <ul class="nav nav-tabs">
                <li class="active"><a data-toggle="tab" href="#tab-1">Básica</a></li>
                <li id="info-estudiante" class=""><a data-toggle="tab" href="#tab-2">Foto</a></li>
                <li id="info-acudiente" class=""><a data-toggle="tab" href="#tab-3">Adjunto</a></li>
            </ul>
            <div class="tab-content">
                <div id="tab-1" class="tab-pane active">
                    <div class="row">
                        <div class="col-sm-12">
                            <?= $form->field($model, 'mensaje')->widget(TinyMce::className(), [
                                'options' => ['rows' => 15],
                                'language' => 'es',
                                'clientOptions' => [
                                    'plugins' => [
                                        "advlist autolink lists link charmap print preview anchor",
                                        "searchreplace visualblocks code fullscreen",
                                        "insertdatetime media image table contextmenu paste"
                                    ],
                                    'toolbar' => "undo redo | copy cut paste pastetext | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link media table image",
                                ]
                            ])->label();?>
                        </div>
                    </div>
                </div>    
                <div id="tab-2" class="tab-pane">
                    <div class="row">
                        <div class="col-sm-12">
                            <?= $form->field($model, 'foto')->widget(FileInput::classname(), [
                                    'options' => ['accept'=>'image/*'],
                                    'pluginOptions'=>[
                                        'allowedFileExtensions'=>['jpg', 'gif', 'png', 'bmp'],
                                        'showUpload' => false,
                                        'initialPreview' => false,
                                        'overwriteInitial' => false,
                                        'browseClass' => 'btn btn-primary',
                                        'uploadClass' => 'btn btn-success',
                                        'removeClass' => 'btn btn-danger',
                                        
                                        ],
                                ]); 
                            ?>
                        </div>
                    </div>
                </div>
                <div id="tab-3" class="tab-pane">
                    <div class="row">
                        <div class="col-sm-12">
                            <?= $form->field($model, 'adjunto')->widget(FileInput::classname(), [
                                    'options' => ['multiple' => false],
                                    'pluginOptions'=>[
                                        //'uploadUrl' => Url::to(['/site/file-upload']),
                                        'allowedFileExtensions'=>['pdf','doc', 'docx'],
                                        'initialPreview' => false,
                                        'previewFileType' => 'any',
                                        'showUpload' => false,
                                        'overwriteInitial' => false,
                                        'browseClass' => 'btn btn-primary',
                                        'uploadClass' => 'btn btn-success',
                                        'removeClass' => 'btn btn-danger',

                                        ],
                                ])->label('Adjuntos:'); 
                            ?>
                        </div>
                    </div>
                </div>
            </div> 
        </div>
        
        <div class="col-sm-12">
            <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
        </div>
    </div>
    
    <?php ActiveForm::end(); ?>