<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Campanaitem */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Campanaitem'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="campanaitem-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Campanaitem').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        [
            'attribute' => 'campana0.campana',
            'label' => Yii::t('app', 'Campana'),
        ],
        [
            'attribute' => 'tercero0.id',
            'label' => Yii::t('app', 'Tercero'),
        ],
        'mensaje:ntext',
        'adjunto:ntext',
        'foto',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    <div class="row">
        <h4>Campana<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnCampana = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'grado',
        'grupo',
        'fecha_inicio',
        'fecha_fin',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->campana0,
        'attributes' => $gridColumnCampana    ]);
    ?>
    <div class="row">
        <h4>Tercero<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnTercero = [
        ['attribute' => 'id', 'visible' => false],
        'identificacion',
        'tipo',
        'primer_nombre',
        'segundo_nombre',
        'primer_apellido',
        'segundo_apellido',
        'genero',
        'tipo_tercero',
        'fecha_nacimiento',
        'departamento_nacimiento',
        'municipio_nacimiento',
        'pais',
        'rh',
        'religion',
        'etnia',
        'eps',
        'direccion',
        'departamento_residencia',
        'municipio_residencia',
        'barrio',
        'fijo',
        'movil',
        'email',
        'foto',
        'firma',
        'estrato',
        'situacion',
        'codigo_desplazado',
        'departamento_desplazado',
        'municipio_desplazado',
        'codigo_sisben',
        'codigo_familia_accion',
        'capacidad',
        'medicamentos',
        'alergias',
        'discapacidad',
        'discapacidad_certificada',
        'subsidio',
        'recurso',
        'bienestar',
        'heroe',
        'fuerza_publica',
        'sector',
        'resguardo',
        'departamento_resguardo',
        'cabeza_familia',
        'activo',
        [
            'attribute' => 'estado0.id',
            'label' => Yii::t('app', 'Estado'),
        ],
        'bloqueo',
    ];
    echo DetailView::widget([
        'model' => $model->tercero0,
        'attributes' => $gridColumnTercero    ]);
    ?>
    
    <div class="row">
<?php
if($providerCampanaVoto->totalCount){
    $gridColumnCampanaVoto = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            [
                'attribute' => 'campana0.campana',
                'label' => Yii::t('app', 'Campana')
            ],
                        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCampanaVoto,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-campana-voto']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Campana Voto')),
        ],
        'export' => false,
        'columns' => $gridColumnCampanaVoto
    ]);
}
?>

    </div>
</div>
