<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Campanatipo */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Campanatipo'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="campanatipo-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= Yii::t('app', 'Campanatipo').' '. Html::encode($this->title) ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a(Yii::t('app', 'Update'), ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        [
            'attribute' => 'tipoTercero.id',
            'label' => Yii::t('app', 'Tipo Tercero'),
        ],
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]);
?>
    </div>
    
    <div class="row">
<?php
if($providerCampana->totalCount){
    $gridColumnCampana = [
        ['class' => 'yii\grid\SerialColumn'],
            ['attribute' => 'id', 'visible' => false],
            'campana',
                        [
                'attribute' => 'grado0.grado',
                'label' => Yii::t('app', 'Grado')
            ],
            [
                'attribute' => 'grupo0.grupo',
                'label' => Yii::t('app', 'Grupo')
            ],
            'fecha_inicio',
            'fecha_fin',
            'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerCampana,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-campana']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode(Yii::t('app', 'Campana')),
        ],
        'export' => false,
        'columns' => $gridColumnCampana
    ]);
}
?>

    </div>
    <div class="row">
        <h4>TipoTercero<?= ' '. Html::encode($this->title) ?></h4>
    </div>
    <?php 
    $gridColumnTipoTercero = [
        ['attribute' => 'id', 'visible' => false],
        'tipo',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model->tipoTercero,
        'attributes' => $gridColumnTipoTercero    ]);
    ?>
</div>
