<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;

use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

use kartik\widgets\Select2;
use kartik\widgets\DepDrop;


use backend\models\Sede;
use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
?>


    <?php 
        $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                          'enctype'=>'multipart/form-data',
                        ]
        ]); 
    ?>


<div class="row">
    <div class = "col-sm-12">
        <?= $form->errorSummary($model); ?>
    </div>
</div>

<div class="row gutter">
  <div class="col-lg-3 col-md-4 col-sm-12 col-xs-12">
    <div class="thumbnail">
      
      <?
            echo Html::img($model->docentes->foto ? '@web/uploads/thumbnail/sm-'.$model->docentes->foto : '@web/images/user.jpg', ['class'=>'foto-perfil img-circle img-responsive']); 

            echo "<div class='clear'></div>";
            
            echo '<h4 class="center-align-text">'.$model->docentes->nombre.'</h4>';
      ?>               
        
        <div class="clear"></div> 

        <!--
        <div class="progress m-t-xs full progress-small">
            <div style="width: 65%" aria-valuemax="100" aria-valuemin="0" aria-valuenow="65" role="progressbar" class=" progress-bar progress-bar-success">
                <span class="sr-only">35% Complete (success)</span>
            </div>
        </div>
        -->
        
        <div class="clear"></div> 

            
            <p class="btn-stack center-align-text">
            
                <? 

                    $grupos = Grupo::find()->where(['director' => $model->docente])->all();

                    foreach ($grupos as $grupo) {
                        echo "<label class='btn btn-info'><i class='fas fa-star text-warning'></i> Grupo " .$grupo->grupo. "</label>";
                    }
                ?>
            
            
                <?php

                    if ($model->docentes->estado == NULL) 
                    {
                        echo '<label class="btn btn-default">Sin Definir Estado</label>';
                    }
                    elseif($model->docentes->estado == '5')
                    {
                        echo '<label class="btn btn-success">'.$model->docentes->estados->estado.'</label>';
                    }
                    elseif ($model->docentes->estado == '6') 
                    {
                        echo '<label class="btn btn-danger">'.$model->docentes->estados->estado.'</label>';
                    }
                ?>
          </p>

    </div>
    <br>
  </div>

            
    <div class="col-lg-9 col-md-8 col-sm-12 col-xs-12">

        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Carga Académica</h3>
            </div>

            <div class="table-responsive" >

                <?= $form->field($model, 'docente')->hiddenInput(['value'=> Yii::$app->session->get('__docente')])->label(false); ?>
                
                <div class="col-sm-12 col-xs-12">

                    <?php
                        if (!$model->isNewRecord)
                        {
                            $model->sede =  $model->grupos->sede;
                        }
                    ?>

                    <?= $form->field($model, 'sede')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Sede::find()->orderBy('id')->asArray()->all(), 'id', 'sede'),
                        'options' => ['placeholder' => 'Seleccione la Sede'],
                        'pluginOptions' => [
                            'allowClear' => true
                        ],
                    ])->label(false); ?>
                </div>    
                <div class="col-sm-6 col-xs-12">
                    <?php
                        if (!$model->isNewRecord)
                        {
                            $model->grado =  $model->grupos->grado;
                        }
                    ?>
                    <?= $form->field($model, 'grado')->widget(Select2::classname(), [
                        'data' => ArrayHelper::map(Grado::find()->orderBy('id')->asArray()->all(), 'id', 'grado'),
                        'pluginOptions' => [
                            'placeholder' => 'Seleccione Grado',
                            'allowClear' => true,
                        ],
                    ])->label(false) ?>
                </div>

                <?php
                    if (!$model->isNewRecord)
                    {
                        $grupo = ArrayHelper::map(Grupo::find()->where(['grado' => $model->grupos->grado])->orderBy('id')->asArray()->all(), 'id', 'grupo');
                    }
                    else
                    {
                        if ($model->grupo != '')
                        {
                            $grupo = ArrayHelper::map(Grupo::find()->where(['grado' => $model->grupos->grado])->andWhere(['sede' => $model->sede])->orderBy('id')->asArray()->all(), 'id', 'grupo');
                        }
                        else
                        {
                            $grupo = NULL;
                        }
                    }
                ?>
        
                <div class="col-sm-6 col-xs-12">    
                    <?= $form->field($model, 'grupo')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data' => $grupo,
                        'pluginOptions'=>[
                            'placeholder'=>'Seleccione el Grupo',
                            'depends'=>['carga-sede', 'carga-grado'],
                            'url'=>Url::to(['publica/findgrupos']),
                        ]
                    ])->label(false);
                    ?>  
                </div>       
                <?php
                    if (!$model->isNewRecord)
                    {
                        $asignatura = ArrayHelper::map(Asignatura::find()->where(['grado' => $model->grupos->grado])->andWhere(['eliminado_por' => '0'])->orderBy('id')->asArray()->all(), 'id', 'asignatura');
                    }
                    else
                    {
                        if ($model->grado != '')
                        {
                            $asignatura = ArrayHelper::map(Asignatura::find()->where(['grado' => $model->grado])->andWhere(['eliminado_por' => '0'])->orderBy('id')->asArray()->all(), 'id', 'asignatura');
                        }
                        else
                        {
                            $asignatura = NULL;    
                        }
                        
                    }                        
                ?>
                <div class="col-sm-6">    
                    <?= $form->field($model, 'asignatura')->widget(DepDrop::classname(), [
                        'type'=>DepDrop::TYPE_SELECT2,
                        'data'=> $asignatura,
                        'options'=>['id'=>'asignatura-id', 'placeholder'=>'Seleccione la Asignatura'],
                        'pluginOptions'=>[
                            'multiple' => true,
                            'depends'=>['carga-grupo'],
                            'url'=>Url::to(['findasignaturas']),
                        ]
                    ]);
                    ?>  
                </div>

                <div class="col-sm-3">     
    
                    <?= $form->field($model, 'director_area')->widget(SwitchInput::classname(), ['pluginOptions' => [
                        'size' => 'medium',
                        'onColor' => 'primary',
                        'offColor' => 'warning',
                        'onText'=>'Si',
                        'offText'=>'No'
                    ]]) 
                    ?>
                </div>

              

                <div class="col-sm-2" style="margin-top: 25px;">
                    <?= Html::submitButton($model->isNewRecord ? '<i class="far fa-plus"></i> Agregar' : '<i class="far fa-pencil"></i> Editar', ['id'=>'guardar', 'class' => $model->isNewRecord ? 'btn btn-block btn-success' : 'btn btn-block btn-primary']) ?>
                </div>
            </div>
        </div>


    <?php if(count($cargas) > 0 ) { ?>
            
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title text-primary"><i class="fas fa-check"></i> Carga Académica Asignada</h3>
            </div>

            <div class="table-responsive" >
                <div class="col-sm-12">
                    <?php

                        $dataProvider = new ArrayDataProvider([
                            'allModels' => $cargas,
                            'key' => 'id'
                        ]);
                        
                        $gridColumns = [
                            ['class' => 'yii\grid\SerialColumn'],
                            [
                                'attribute' => 'asignaturas.asignatura',
                                'label' => 'Asignatura',
                            ],
                            [
                                'attribute' => 'grupos.sedes.sede',
                                'label' => 'Sede',
                                'visible' => false,
                            ],
                            [
                                'attribute' => 'grupos.grupo',
                                'label' => 'Grupo',
                            ],
                            [
                                'attribute' => 'grupos.jornadas.jornada',
                                'label' => 'Jornada',
                            ],
                            [
                                'class'=>'kartik\grid\BooleanColumn',
                                'attribute'=>'director_area', 
                                'vAlign'=>'middle'
                            ],
                            [
                                'class'=>'kartik\grid\BooleanColumn',
                                'attribute'=>'estado', 
                                'vAlign'=>'middle'
                            ], 
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'template' => '<center>{update} {delete}</center>',
                            ],
                        ];
                        
                        echo GridView::widget([
                            'dataProvider' => $dataProvider,
                            'columns' => $gridColumns,
                            'pjax' => true,
                            'beforeHeader' => [
                                [
                                    'options' => ['class' => 'skip-export']
                                ]
                            ],
                            'export' => [
                                'fontAwesome' => true
                            ],
                            'bordered' => true,
                            'striped' => true,
                            'condensed' => true,
                            'responsive' => true,
                            'hover' => true,
                            'showPageSummary' => false,
                        ]);
                    
                    ?>
                </div>
            </div>
        </div>

    <?php } ?>

    </div>
</div>

    <?php ActiveForm::end(); ?>

