<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model backend\models\CargaSearch */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="row blanco">

    <div class="col-sm-2">
        <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive']); ?>
    </div>    
    
    <div class="col-sm-10">

    <?php $form = ActiveForm::begin([
        'action' => ['index'],
        'method' => 'get',
    ]); ?>
    
    <div class="col-sm-12">
        <?= $form->field($model, 'docente')->widget(\kartik\widgets\Select2::classname(), [
            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Tercero::find()->select(['tercero.id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])->where(['tipo_tercero' => '2'])->andWhere(['eliminado_por' => '0'])->orderBy('primer_apellido')->asArray()->all(), 'id', 'nombre'),
            'options' => ['placeholder' => 'Seleccione el Docente'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    </div>
    

        <? $form->field($model, 'asignatura')->widget(\kartik\widgets\Select2::classname(), [
            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
            'options' => ['placeholder' => 'Choose Asignatura'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    <div class="col-sm-12">
        <?= $form->field($model, 'grupo')->widget(\kartik\widgets\Select2::classname(), [
            'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grupo::find()->orderBy('id')->asArray()->all(), 'id', 'grupo'),
            'options' => ['placeholder' => 'Seleccione Grupo'],
            'pluginOptions' => [
                'allowClear' => true
            ],
        ]) ?>
    </div>
    <div class="col-sm-12">

        <? $form->field($model, 'estado')->textInput(['placeholder' => 'Estado']) ?>
        </div>

        <div class="col-sm-12">
        <div class="custom-options">
            <?= Html::submitButton('<i class="fa fa-search"></i>Buscar', ['class' => 'btn btn-primary']) ?>
            <?= Html::resetButton('<i class="fa fa-eraser"></i>Limpiar', ['class' => 'btn btn-default']) ?>
        </div>
    </div>
    <?php ActiveForm::end(); ?>
  </div>  
</div>
