<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\widgets\Select2;

use backend\models\Tercero;


$this->title = 'Carga Académica';
$this->params['breadcrumbs'][] = ['label' => 'Carga Académica Docente', 'url' => ['index']];

?>


<div class="row">

    <div class="col-sm-2 hidden-xs">
        <?= Html::img('@web/images/sonic-hero.png', ['class'=>'img-responsive hidden-xs animated bounceInUp','style' => 'z-index:0;']); ?>
    </div>    
    
    <div class="col-sm-10 col-xs-12">
    
        <div class="col-sm-12">
            <?php
                    echo "<p class='titulo'>Carga Académica Docente</p>";
                    echo "<p class='observaciones'>Selecciona el docente al cual desea agregar o ver carga académica</p>";
            ?>    
        </div>


        <?php $form = ActiveForm::begin(['id' => 'formulario', 'enableAjaxValidation' => true]); ?>
    
        <? $form->errorSummary($model); ?>
      

            <div class="col-sm-12 col-xs-12">
                <?php  

                    $tercero = Tercero::find()
                                ->select(['tercero.id', new \yii\db\Expression("CONCAT(primer_apellido,' ',IFNULL(segundo_apellido,''),' ',primer_nombre,' ',IFNULL(segundo_nombre, '')) as nombre")])
                                ->where(['tipo_tercero' => '2'])
                                ->andWhere(['eliminado_por' => '0'])
                                ->orderBy('primer_apellido')
                                ->asArray()
                                ->all();
                
                ?>

                 <?= $form->field($model, 'docente')->widget(Select2::classname(), [
                    'data' => ArrayHelper::map($tercero, 'id', 'nombre'),
                    'options' => ['placeholder' => 'Seleccione el Docente'],
                    'hideSearch' => false,
                    'pluginOptions' => [
                        'allowClear' => false,
                    ],
                ])->label(false) ?>
            </div>   


        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="text-align:right; padding-top: 10px;">
            <?= Html::submitButton('<i class="fa fa-check" aria-hidden="true"></i> Seleccionar', ['class' => 'btn btn-warning']) ?>
            <?= Html::a('<i class="fa fa-times" aria-hidden="true"></i><span> Cancelar', false , ['class'=> 'btn btn-danger', 'data-dismiss' => 'modal']) ?>        
        </div>

        <?php ActiveForm::end(); ?>

    </div>
</div>



