<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->desempenoniveles,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'desempeno',
                'width' => '100px',
                'label' => 'Niveles de Desempeño',
                'format' => 'RAW',
                'value' => function($model){
                            return '<h3><span class="label" style="width:50px; background-color:'.$model->desempenos->color.'; color:#fff">'.$model->desempenos->desempeno.'</span></h3>';
                           }, 
                                
        ],
        'descripcion:ntext',
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => function($model){
                    return ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>';
                },
        ],    
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'desempeno-nivel'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
