<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->planAulas,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'docente',
                'label' => 'Docente',
                'value' => function($model){
                    return $model->docentes->nombre;
                },
        ],
        'semana_inicio',
        //'semana_fin',
        [
                'attribute' => 'grados.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'asignaturas.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'grupos.grupo',
                'label' => 'Grupo'
        ],
        //'estandar:ntext',
        [
                'attribute' => 'periodos.periodo',
                'label' => 'Periodo'
        ],
        //'unidad',
        'nombre_unidad',
        /*'horas',
        'derechos:ntext',
        'inicio:ntext',
        'desarrollo:ntext',
        'cierre:ntext',
        'formativa:ntext',
        'articulacion:ntext',
        'recursos:ntext',
        'reflexion:ntext',
        'observaciones:ntext',*/
        [
                'attribute' => 'estado',
                'format' => 'RAW',
                'value' => function($model){
                    return ($model->estado == 1) ? '<span class="label label-success"><span class="glyphicon glyphicon-ok"></span> Activo</span>' : '<span class="label label-danger"><span class="glyphicon glyphicon-remove"></span> Inactivo</span>';
                },
        ], 
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'planaula'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
