<div class="form-group" id="add-desempeno-frd">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;
use backend\models\Grado;
use backend\models\Desempeno;

$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);

if (isset($grado) and $grado != '')
{
    $tipo = Grado::findOne($grado)->tipo_calificacion; 
    $query = Desempeno::find()->where(['tipo_calificacion' => $tipo])->orderBy('desempeno')->asArray()->all();   
}
else
{
    $query = Desempeno::find()->orderBy('desempeno')->asArray()->all();      
}


echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'DesempenoFrd',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        'desempeno' => [
            'label' => 'Desempeño',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map($query, 'id', 'desempeno'),
                'options' => ['placeholder' => 'Nivel de Desempeño'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'fortaleza' => [
                        'label' => 'Fortaleza',
                        'type' => TabularForm::INPUT_TEXTAREA
                        ],
        'debilidad' => [
                        'label' => 'Debilidad',
                        'type' => TabularForm::INPUT_TEXTAREA
                        ],
        'recomendacion' => [
                            'label' => 'Recomendación',
                            'type' => TabularForm::INPUT_TEXTAREA
                            ],
        
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="fas fa-trash text-danger"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowDesempenoFrd(' . $key . '); return false;', 'id' => 'desempeno-frd-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="fas fa-plus"></i>' . ' Agregar', ['type' => 'button', 'id' => 'frdbutton', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowDesempenoFrd()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

