<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;

Pjax::begin();
$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);
echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Desempenonivel',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        'grado' => [
            'label' => 'Grado',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::find()->orderBy('grado')->asArray()->all(), 'id', 'grado'),
                'options' => ['placeholder' => 'Choose Grado'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'asignatura' => [
            'label' => 'Asignatura',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Asignatura::find()->orderBy('asignatura')->asArray()->all(), 'id', 'asignatura'),
                'options' => ['placeholder' => 'Choose Asignatura'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'periodo' => [
            'label' => 'Periodo',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->orderBy('periodo')->asArray()->all(), 'id', 'periodo'),
                'options' => ['placeholder' => 'Choose Periodo'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'desempeno' => [
            'label' => 'Desempeno',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Desempeno::find()->orderBy('desempeno')->asArray()->all(), 'id', 'desempeno'),
                'options' => ['placeholder' => 'Choose Desempeno'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'descripcion' => ['type' => TabularForm::INPUT_TEXTAREA],
        'recomendacion' => ['type' => TabularForm::INPUT_TEXTAREA],
        'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Delete', 'onClick' => 'delRowDesempenonivel(' . $key . '); return false;', 'id' => 'desempeno-nivel-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => '<span class="glyphicon glyphicon-book"></span> ' . 'Desempeno Nivel',
            'type' => GridView::TYPE_INFO,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . 'Add Row', ['type' => 'button', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowDesempenonivel()']),
        ]
    ]
]);
Pjax::end();
?>
