<div class="form-group" id="add-frd">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\Pjax;
use backend\models\Grado;
use backend\models\Desempeno;
use backend\models\Frdtipo;
use kartik\widgets\Select2;


$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);


if (isset($grado) and $grado != '')
{
    $tipo = Grado::findOne($grado)->tipo_calificacion; 
    $query = Desempeno::find()->where(['tipo_calificacion' => $tipo])->orderBy('desempeno')->asArray()->all();   
}
else
{
    $query = Desempeno::find()->orderBy('desempeno')->asArray()->all();      
}

echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Frd',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        "id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        "nivel" => [
            'label' => 'Nivel',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Nivel::find()->orderBy('nivel')->asArray()->all(), 'id', 'nivel'),
                'options' => ['placeholder' => Yii::t('app', 'Choose Nivel')],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        
        'frd_tipo' => [
            'label' => 'Tipo',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => Select2::className(),
            'options' => [
                'data' => ArrayHelper::map(Frdtipo::find()->orderBy('id')->asArray()->all(), 'id', 'tipo'),
                'options' => ['placeholder' => 'Seleccione'],
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'descripcion' => [
            'label' => 'Descripción',
            'type' => TabularForm::INPUT_TEXT
            ],
        
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  'Eliminar', 'onClick' => 'delRowFrd(' . $key . '); return false;', 'id' => 'frd-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="fas fa-plus"></i>' . ' Agregar FRD', ['type' => 'button', 'id' => 'frdbutton', 'class' => 'btn btn-success kv-batch-create', 'onClick' => 'addRowFrd()']),
        ]
    ]
]);
echo  "    </div>\n\n";

?>

