<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Competencia */

$this->title = $model->competencia;
$this->params['breadcrumbs'][] = ['label' => 'Competencias', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="competencia-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Competencia'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        'competencia:ntext',
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnDesempenonivel = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'competencia.competencia',
                'label' => 'Competencia'
        ],
        [
                'attribute' => 'desempeno.desempeno',
                'label' => 'Desempeno'
        ],
        'descripcion:ntext',
        'recomendacion:ntext',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerDesempenonivel,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-desempeno-nivel']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Desempeno Nivel'.' '. $this->title),
        ],
        'columns' => $gridColumnDesempenonivel
    ]);
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnObservacionFrd = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'tipoObservacion.tipo_observacion',
                'label' => 'Tipo Observacion'
        ],
        [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'competencia.competencia',
                'label' => 'Competencia'
        ],
        'observacion:ntext',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerObservacionFrd,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-observacion-frd']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Observacion Frd'.' '. $this->title),
        ],
        'columns' => $gridColumnObservacionFrd
    ]);
?>
    </div>
    
    <div class="row">
<?php
    $gridColumnPlanAula = [
        ['class' => 'yii\grid\SerialColumn'],
        [
                'attribute' => 'tercero.id',
                'label' => 'Docente'
        ],
        'rango',
        'semana_inicio',
        'semana_fin',
        [
                'attribute' => 'grado.grado',
                'label' => 'Grado'
        ],
        [
                'attribute' => 'asignatura.asignatura',
                'label' => 'Asignatura'
        ],
        [
                'attribute' => 'grupo.grupo',
                'label' => 'Grupo'
        ],
        'estandar:ntext',
        [
                'attribute' => 'periodo.periodo',
                'label' => 'Periodo'
        ],
        [
                'attribute' => 'competencia.competencia',
                'label' => 'Competencia'
        ],
        'unidad',
        'nombre_unidad',
        'horas',
        'derechos:ntext',
        'inicio:ntext',
        'desarrollo:ntext',
        'cierre:ntext',
        'formativa:ntext',
        'articulacion:ntext',
        'recursos:ntext',
        'reflexion:ntext',
        'observaciones:ntext',
        'estado',
    ];
    echo Gridview::widget([
        'dataProvider' => $providerPlanAula,
        'pjax' => true,
        'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-plan-aula']],
        'panel' => [
            'type' => GridView::TYPE_PRIMARY,
            'heading' => Html::encode('Plan Aula'.' '. $this->title),
        ],
        'columns' => $gridColumnPlanAula
    ]);
?>
    </div>
</div>
