<?php


use yii\helpers\Html;
use kartik\export\ExportMenu;
use kartik\grid\GridView;
use kartik\dynagrid\DynaGrid;
use kartik\widgets\DepDrop;
use yii\helpers\Url;


$this->title = 'Competencias';
$this->params['breadcrumbs'][] = $this->title;


$this->params['actions'][] = ['label' => 'Buscar', 'url' => false, 'icon' => '<i class="far fa-search"></i>', 'class' => 'primary search-button', 'id' => 'enviar'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'Imprimir', 'url' => 'imprimir', 'icon' => '<i class="far fa-print"></i>', 'class' => 'default'];


$search = "$('.search-button').click(function(){
	$('.search-form').toggle(1000);
	return false;
});";
$this->registerJs($search);

?>
<div class="competencia-index">

    <div class="search-form" style="display:none">
        <?=  $this->render('_search', ['model' => $searchModel]); ?>
    </div>
    <?php 

        if(Yii::$app->session->get('__tipo') == 2)
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'concat(asignatura.asignatura, " - " , grado.grado) as asignatura'])->joinWith(['asignaturas', 'asignaturas.grados'])->where(['docente' => Yii::$app->session->get('__tercero')])->asArray()->all();
        }
        else
        {
            $asignaturas = \backend\models\Carga::find()->select(['asignatura.id as id', 'asignatura.asignatura as asignatura'])->joinWith(['asignaturas'])->asArray()->all();   
        }
    
    $gridColumn = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        'competencia:ntext',
        [
            'attribute' => 'grado',
            'label' => 'Grado',
            'value' => function($model){                   
                return $model->grados->grado;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::getGradobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grado'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Grado', 'id' => 'grid-competencia-search-grado']
        ],
        [
            'attribute' => 'asignatura',
            'label' => 'Asignatura',
            'value' => function($model){                   
                return $model->asignaturas->asignatura;                   
            },
            'filterType' => GridView::FILTER_SELECT2,
            'filter' => \yii\helpers\ArrayHelper::map($asignaturas, 'id', 'asignatura'),
            'filterWidgetOptions' => [
                'pluginOptions' => ['allowClear' => true],
            ],
            'filterInputOptions' => ['placeholder' => 'Asignatura', 'id' => 'grid-competencia-search-asignatura']
        ],

        [
                'attribute' => 'periodo',
                'label' => 'Periodo',
                'value' => function($model){                   
                    return $model->periodos->periodo;                   
                },
                'filterType' => GridView::FILTER_SELECT2,
                'filter' => \yii\helpers\ArrayHelper::map(\backend\models\Periodo::find()->asArray()->all(), 'id', 'periodo'),
                'filterWidgetOptions' => [
                    'pluginOptions' => ['allowClear' => true],
                ],
                'filterInputOptions' => ['placeholder' => 'Periodo', 'id' => 'grid-competencia-search-periodo']
            ],
        [
            'class' => 'yii\grid\ActionColumn',
        ],
    ]; 
    ?>

<?
    $dynagrid = DynaGrid::begin([
        'columns'=> $gridColumn,
        'theme'=>'panel-default',
        'showPersonalize'=>true,
        'storage'=>DynaGrid::TYPE_DB,
        'gridOptions'=>[
            'dataProvider'=>$dataProvider,
            'filterModel'=>$searchModel,
            'showPageSummary'=>false,
            'floatHeader'=>false,
            'pjax'=> true,
            'panel'=>[
                'heading' => false,
                //'heading'=>'<i class="fa fa-users"></i>  Terceros',
                //'before' =>  '<div style="padding-top: 7px;"><em>Estudiantes, Docentes, Administrativos y Acudientes.</em></div>',
                //'after' => '{summary}',
                'footer'=> '{summary}',
            ],        
            'toolbar' =>  [
                ['content'=>
                    Html::a('<i class="fa fa-plus"></i>', ['create'], ['data-pjax'=>0, 'class' => 'btn btn-success', 'title'=>'Crear']) . ' '.
                    Html::a('<i class="fa fa-repeat"></i>', ['index'], ['data-pjax'=>0, 'class' => 'btn btn-default', 'title'=>'Volver a Cargar'])
                ],
                ['content'=>'{dynagridFilter}{dynagridSort}{dynagrid}{export}{toggleData}'],
                
            ],
        ],
        'options'=>['id'=>'competencias'] // a unique identifier is important
    ]);
    

    DynaGrid::end();
?>

</div>
