<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Competencia */

$this->title = 'Competencia Creada';
$this->params['breadcrumbs'][] = ['label' => 'Competencia', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'PDF', 'url' => 'pdf', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];

?>
<div class="competencia-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Competencia Creada' ?></h2>
        </div>
        <div class="col-sm-3" style="margin-top: 15px">
            
            <?= Html::a('Actualizar', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
            <?= Html::a('Eliminar', ['delete', 'id' => $model->id], [
                'class' => 'btn btn-danger',
                'data' => [
                    'confirm' => 'Esta seguro de eliminar este registro?',
                    'method' => 'post',
                ],
            ])
            ?>
        </div>
    </div>

    <div class="row">
        <?php 
            $gridColumn = [
                ['attribute' => 'id', 'visible' => false],
                'competencia:ntext',
                [
                    'attribute' => 'grados.grado',
                    'label' => 'Grado',
                ],
                [
                    'attribute' => 'asignaturas.asignatura',
                    'label' => 'Asignatura',
                ],
                [
                    'attribute' => 'periodos.periodo',
                    'label' => 'Periodo',
                ],
                [
                    'attribute' => 'estandares.estandar',
                    'label' => 'Estandar',
                ],
            ];
            echo DetailView::widget([
                'model' => $model,
                'attributes' => $gridColumn
            ]);
        ?>
    </div>
    
    
    <div class="row">
        <?php
            if($providerFrd->totalCount){
                $gridColumnFrd = [
                    ['class' => 'yii\grid\SerialColumn'],
                        ['attribute' => 'id', 'visible' => false],
                                    [
                            'attribute' => 'desempenos.desempeno',
                            'label' => 'Desempeño'
                        ],
                        [
                            'attribute' => 'tipos.tipo',
                            'label' => 'Tipo'
                        ],
                        'descripcion:ntext',
                ];
                echo Gridview::widget([
                    'dataProvider' => $providerFrd,
                    'pjax' => true,
                    'pjaxSettings' => ['options' => ['id' => 'kv-pjax-container-frd']],
                    'panel' => [
                        'type' => GridView::TYPE_DEFAULT,
                        'heading' => '<span class="glyphicon glyphicon-book"></span> ' . Html::encode('Frd'),
                    ],
                    'export' => false,
                    'columns' => $gridColumnFrd
                ]);
            }
        ?>
    </div>
    
</div>
