<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\models\Nivel;
use backend\models\Frd;

$this->registerCss("
.list-group-item.active, .list-group-item.active:hover, .list-group-item.active:focus {
  z-index: 1;
  color: #555;
  background-color: #DDD;
  border-color: #DDD;
}
");


$this->registerJs("
$('#list-tab a').on('click', function (e) {
      e.preventDefault()
      $(this).tab('show')
    })

");

?>


<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>

<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>



<script type="text/javascript">
    
    function eliminar_nivel(id)
    {

      swal({
          title: '¿Estás seguro?',
          text: 'Deseas eliminar el nivel y todos sus frds del sistema?',
          type: 'warning',
          showCancelButton: true,
          confirmButtonClass: 'btn-warning',
          confirmButtonText: 'Si, estoy seguro!',
          cancelButtonText: 'No, Cancelar',
          closeOnConfirm: false,
          closeOnCancel: false
        },
        function(isConfirm) {
          if (isConfirm) 
          {
            $.ajax({
                    type: 'POST',
                    url: '<?= Url::to(["nivel/delete"]) ?>',
                    data: {id : id},
                    success: function (data) {

                        $("#nivel-"+data).remove();
                        $("#list-"+data).remove();

                        swal({
                            title: 'Eliminado!',
                            text: 'Se ha eliminado el registro satisfactoriamente.',
                            type: 'success',
                            allowOutsideClick: false,
                            timer: 3000,
                        });

                    }
            });  
          } 
          else 
          {
              swal({
                title: 'Cancelado!',
                text: 'Haz cancelado eliminar el registro.',
                type: 'error',
                timer: 3000})
          }
      });
    }    

    function eliminar_frd(id)
    {

      swal({
          title: '¿Estás seguro?',
          text: 'Deseas eliminar el frd del sistema?',
          type: 'warning',
          showCancelButton: true,
          confirmButtonClass: 'btn-warning',
          confirmButtonText: 'Si, estoy seguro!',
          cancelButtonText: 'No, Cancelar',
          closeOnConfirm: false,
          closeOnCancel: false
        },
        function(isConfirm) {
          if (isConfirm) 
          {
            $.ajax({
                    type: 'POST',
                    url: '<?= Url::to(["frd/delete"]) ?>',
                    data: {id : id},
                    success: function (data) {

                        $("#frd-"+data).remove();

                        swal({
                            title: 'Eliminado!',
                            text: 'Se ha eliminado el registro satisfactoriamente.',
                            type: 'success',
                            allowOutsideClick: false,
                            timer: 3000,
                        });

                    }
            });  
          } 
          else 
          {
              swal({
                title: 'Cancelado!',
                text: 'Haz cancelado eliminar el registro.',
                type: 'error',
                timer: 3000})
          }
      });
    }  

</script>

<div class="row" role="tabpanel">
  <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">

    <?= Html::button('<i class="fa fa-plus" aria-hidden="true"></i> Agregar Niveles', ['value' => Url::to(['nivel/add','competencia' => $model->id]), 'id' => 'addnivel', 'title' => Yii::t('app', 'Agregar Niveles de Desempeño'), 'class' => 'showModalButton btn btn-block btn-primary', 'disabled' => false]); ?>
    <br>
    <div class="list-group" id="list-tab" role="tablist">
        <? 
            $x = 1;
                        
            $niveles = Nivel::find()->Where(['competencia' => $model->id])->andWhere(['eliminado_por' => '0'])->all();
            

            foreach ($niveles as $nivel) { ?>
                <a class="list-group-item list-group-item-action <?= $x == 1 ? 'active show' : '' ?>" id="nivel-<?= $nivel->id ?>" data-toggle="list" href="#list-<?= $nivel->id ?>" role="tab" aria-controls="list-<?= $nivel->id ?>">
                    <?= $nivel->nivel ?>
                    
                    <div class="btn-group"  style="float:right; padding-left: 10px;">

                        <?= Html::button('<i id="trash" class="fa fa-trash-alt" aria-hidden="true"></i>', [
                                'value' => Url::to(['nivel/delete', 'id' => $nivel->id]), 
                                'data-toggle' => 'tooltip', 
                                'title' => Yii::t('app', 'Eliminar'), 
                                'class' => 'btn btn-xs btn-danger btn-xs', 
                                'style' => 'float:right;',
                                'onClick' => 'eliminar_nivel('.$nivel->id.')',
                            ]); ?>

                        <?= Html::button('<i id="edit" class="fa fa-pencil" aria-hidden="true"></i>', [
                                'value' => Url::to(['nivel/update', 'id' => $nivel->id]), 
                                'data-toggle' => 'tooltip', 
                                'title' => Yii::t('app', 'Editar'), 
                                'class' => 'showModalButton btn btn-xs btn-success btn-xs', 
                                'style' => 'float:right;',
                            ]); ?>

                        <?= Html::button('<i id="showCreateFRD" class="fa fa-plus" aria-hidden="true"></i> FRD', ['value' => Url::to(['frd/add','competencia' => $nivel->competencia, 'nivel' => $nivel->id]), 'id' => 'addbutton', 'title' => Yii::t('app', 'Agregar FRD'), 'class' => 'showModalButton btn btn-xs btn-primary', 'disabled' => false]); ?>


                    </div>
                    <?= '<span class="badge badge-pill" style="color:#fff; background-color:'.$nivel->desempenos->color.';">'.$nivel->desempenos->desempeno.'</span>'; ?>
                </a>
        <? $x++; } ?>
      
    </div>
  </div>
  <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12">
    <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Fortalezas, Recomendaciones y Debilidades.</h3>
    <br>
    <div class="tab-content" id="nav-tabContent-frd" style="padding: 0px; border: none;">
        <?  
            $x = 1;

            foreach ($niveles as $nivel) { ?>
                <div class="tab-pane fade <?= $x == 1 ? 'active in' : '' ?>" id="list-<?= $nivel->id ?>" role="tabpanel" aria-labelledby="list-<?= $nivel->id ?>-list">

                    <ul id="list-frd" class="list-group">
                        <?  

                            $frds = Frd::find()->where(['nivel' => $nivel->id])->andWhere(['eliminado_por' => '0'])->all();
                            

                            if(count($frds) == 0)
                            {
                                echo '<li id="no-item" class="list-group-item d-flex justify-content-between align-items-center">No hay registros de fortalezas, recomendaciones y debilidades almacenados.</li>';
                            }
                            else
                            {
                                foreach ($frds as $frd) {
                                    
                                    if ($frd->frd_tipo==1) $color="success";
                                    if ($frd->frd_tipo==2) $color="info";
                                    if ($frd->frd_tipo==3) $color="danger"; 
                                    if ($frd->frd_tipo==4) $color="warning";
                                     
                                    echo '<li id="frd-'.$frd->id.'" class="list-group-item d-flex justify-content-between align-items-center">'.$frd->descripcion;
                                    
                                    
                                    
                                    echo '<div class="btn-group" style="float:right; padding-left: 10px;">';

                                    
                                    echo Html::button('<i id="trash" class="fa fa-trash-alt" aria-hidden="true"></i>', [
                                                        'value' => Url::to(['frd/delete', 'id' => $frd->id]), 
                                                        'data-toggle' => 'tooltip', 
                                                        'title' => Yii::t('app', 'Eliminar'), 
                                                        'class' => 'btn btn-danger btn-xs', 
                                                        'style' => 'float:right;',
                                                        'onClick' => 'eliminar_frd('.$frd->id.')',
                                                    ]);

                                    echo Html::button('<i id="edit" class="fa fa-pencil" aria-hidden="true"></i>', [
                                                        'value' => Url::to(['frd/update', 'id' => $frd->id]), 
                                                        'data-toggle' => 'tooltip', 
                                                        'title' => Yii::t('app', 'Editar'), 
                                                        'class' => 'showModalButton btn btn-success btn-xs', 
                                                        'style' => 'float:right;',
                                                    ]);
                                    
                                    echo '</div>';

                                    echo '<span class="badge badge-'.$color.' badge-pill">'.$frd->tipos->tipo.'</span>';
                                    echo '</li>';

                                }
                            }
                        ?>
                    </ul>
                </div>
        
        <? $x++; }?>
    </div>
  </div>
</div>
