<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->planAulas,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        [
                'attribute' => 'docente0.id',
                'label' => Yii::t('app', 'Docente')
            ],
        'rango',
        'semana_inicio',
        'semana_fin',
        [
                'attribute' => 'grado0.grado',
                'label' => Yii::t('app', 'Grado')
            ],
        [
                'attribute' => 'asignatura0.asignatura',
                'label' => Yii::t('app', 'Asignatura')
            ],
        [
                'attribute' => 'grupo0.grupo',
                'label' => Yii::t('app', 'Grupo')
            ],
        [
                'attribute' => 'periodo0.periodo',
                'label' => Yii::t('app', 'Periodo')
            ],
        'unidad',
        'nombre_unidad',
        'horas',
        'derechos:ntext',
        'inicio:ntext',
        'desarrollo:ntext',
        'cierre:ntext',
        'formativa:ntext',
        'articulacion:ntext',
        'recursos:ntext',
        'reflexion:ntext',
        'observaciones:ntext',
        'metodo',
        'adjunto',
        'descargas',
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'plan-aula'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
