<?php
use kartik\grid\GridView;
use yii\data\ArrayDataProvider;

    $dataProvider = new ArrayDataProvider([
        'allModels' => $model->planMejoramientos,
        'key' => 'id'
    ]);
    $gridColumns = [
        ['class' => 'yii\grid\SerialColumn'],
        ['attribute' => 'id', 'visible' => false],
        [
                'attribute' => 'docente0.id',
                'label' => Yii::t('app', 'Docente')
            ],
        'fecha_inicio',
        'fecha_fin',
        [
                'attribute' => 'grado0.grado',
                'label' => Yii::t('app', 'Grado')
            ],
        [
                'attribute' => 'asignatura0.asignatura',
                'label' => Yii::t('app', 'Asignatura')
            ],
        [
                'attribute' => 'grupo0.grupo',
                'label' => Yii::t('app', 'Grupo')
            ],
        [
                'attribute' => 'periodo0.periodo',
                'label' => Yii::t('app', 'Periodo')
            ],
        'tematica:ntext',
        'productivo:ntext',
        'cognitivo:ntext',
        'valorativo:ntext',
        'observaciones:ntext',
        'metodo',
        'adjunto',
        'descargas',
        'estado',
        [
            'class' => 'yii\grid\ActionColumn',
            'controller' => 'plan-mejoramiento'
        ],
    ];
    
    echo GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => $gridColumns,
        'containerOptions' => ['style' => 'overflow: auto'],
        'pjax' => true,
        'beforeHeader' => [
            [
                'options' => ['class' => 'skip-export']
            ]
        ],
        'export' => [
            'fontAwesome' => true
        ],
        'bordered' => true,
        'striped' => true,
        'condensed' => true,
        'responsive' => true,
        'hover' => true,
        'showPageSummary' => false,
        'persistResize' => false,
    ]);
