<?php

use yii\helpers\Html;
use kartik\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\helpers\Url;
use kartik\switchinput\SwitchInput;
use kartik\widgets\Select2;
use kartik\widgets\TouchSpin;
use kartik\widgets\DepDrop;
use yii\widgets\DetailView;
use kartik\grid\GridView;

use backend\models\Grado;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Periodo;
use backend\models\Estandar;


\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Frd', 
        'relID' => 'frd', 
        'value' => \yii\helpers\Json::encode($model->frds),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);
\mootensai\components\JsBlock::widget(['viewFile' => '_script', 'pos'=> \yii\web\View::POS_END, 
    'viewParams' => [
        'class' => 'Nivel', 
        'relID' => 'nivel', 
        'value' => \yii\helpers\Json::encode($model->nivels),
        'isNewRecord' => ($model->isNewRecord) ? 1 : 0
    ]
]);

    $this->registerJs("

    $('#grado-id').change(function(){

        grado = $('#grado-id').val();
        asignatura = $('#asignatura-id').val();
        periodo = $('#periodo-id').val();

        if(grado > 0 && asignatura > 0 && periodo > 0)
        {
            //$('#addbutton').prop('disabled', false);
            $('#nivelbutton').prop('disabled', false);
        }
 
    });

    $('#asignatura-id').change(function(){
        
        grado = $('#grado-id').val();
        asignatura = $('#asignatura-id').val();
        periodo = $('#periodo-id').val();

        if(grado > 0 && asignatura > 0 && periodo > 0)
        {
            
            //$('#addbutton').prop('disabled', false);
            $('#nivelbutton').prop('disabled', false);
        }
 
    });

        $('#periodo-id').change(function(){

        grado = $('#grado-id').val();
        asignatura = $('#asignatura-id').val();
        periodo = $('#periodo-id').val();

        if(grado > 0 && asignatura > 0 && periodo > 0)
        {
            
            //$('#addbutton').prop('disabled', false);
            $('#nivelbutton').prop('disabled', false);
        }
 
    });"
    );
?>
    
    <?php $form = ActiveForm::begin([
        'validateOnSubmit' => true,
        'enableAjaxValidation' => true,
        'type' => ActiveForm::TYPE_VERTICAL,
        'options' => ['class' => 'main-task-form',
                      'id' => 'formulario',
                      'enctype'=>'multipart/form-data',
                    ]
    ]); ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Competencia</h3>
    </div>

    <div class="panel-body" >

        <?= $form->errorSummary($model); ?>


        <?= $form->field($model, 'id', ['template' => '{input}'])->textInput(['style' => 'display:none'])->label(false); ?>

        <? 
            if($model->isNewRecord && Yii::$app->request->get('grado') != NULL)
            {
                $model->grado = Yii::$app->request->get('grado');
            }    
            
        ?>
        
        <div class="col-sm-3">
            <?= $form->field($model, 'grado')->widget(Select2::classname(), [
                'data' => \yii\helpers\ArrayHelper::map(\backend\models\Grado::getGradobyDocente(Yii::$app->session->get('__tercero')), 'id', 'grado'),
                'options' => ['id'=>'grado-id'],
                'pluginOptions' => [
                    'placeholder' => 'Seleccione Grado',
                    'allowClear' => false,
                ],
            ]) ?>
        </div>


        <div class="col-sm-6">
            
            <? 
                if($model->isNewRecord && Yii::$app->request->get('grado') != NULL)
                {
                    $model->asignatura = Yii::$app->request->get('asignatura'); 
                }
                //
            ?>

            <?= $form->field($model, 'asignatura')->widget(DepDrop::classname(), [
                'type'=>DepDrop::TYPE_SELECT2,
                'data' => ArrayHelper::map(Asignatura::find()->where(['=', 'grado', $model->grado])->orderBy('id')->asArray()->all(), 'id', 'asignatura'),
                'options'=>['id'=>'asignatura-id'],
                'pluginOptions'=>[
                    'placeholder'=>'Seleccione la Asignatura',
                    'depends'=>['grado-id'],
                    'url'=>Url::to(['publica/findasignaturas']),
                ]
            ]);
            ?>  
        </div>


        <div class="col-sm-3"> 
            <?  
                if ($model->isNewRecord)
                {
                    $periodo = new Periodo();
                    $model->periodo = $periodo->actual->id;    
                }
            ?>
            <?= $form->field($model, 'periodo')->widget(Select2::classname(), [
                'data' => ArrayHelper::map(Periodo::find()->where(['estado' => 1])->orderBy('id')->asArray()->all(), 'id', 'periodo'),
                'options' => ['id'=>'periodo-id',],
                'pluginOptions' => [
                    'placeholder' => 'Seleccione el Periodo',
                    'allowClear' => true
                ],
            ]) ?>
        </div>

        <div class="col-sm-12">
            
            <? 
                if($model->isNewRecord && Yii::$app->request->get('grado') != NULL && Yii::$app->request->get('asignatura') != NULL)
                {
                    //$model->estandar = (Yii::$app->request->get('asignatura')); 
                    $estandares = Estandar::find()
                                    ->where(['grado' => Yii::$app->request->get('grado')])
                                    ->andwhere(['asignatura' => Yii::$app->request->get('asignatura')])
                                    ->andwhere(['periodo' => $model->periodo])
                                    ->orderBy('id')->asArray()->all();

                    $estandar = ArrayHelper::map($estandares, 'id', 'estandar');                                    
                }

                elseif(!$model->isNewRecord)
                {
                    $estandares = Estandar::find()
                                    ->where(['grado' => $model->grado])
                                    ->andwhere(['asignatura' => $model->asignatura])
                                    ->andwhere(['periodo' => $model->periodo])
                                    ->orderBy('id')->asArray()->all();
                    $estandar = ArrayHelper::map($estandares, 'id', 'estandar');                                    
                }

                if($model->isNewRecord)
                {
                    $estandar = NULL;
                    //$estandares = Estandar::find()->orderBy('id')->asArray()->all();
                    //$estandar = ArrayHelper::map($estandares, 'id', 'estandar');                                    
                } 
                //'data' => ArrayHelper::map(Estandar::find()->orderBy('id')->asArray()->all(), 'id', 'estandar'),
            ?>

            <?= $form->field($model, 'estandar')->widget(DepDrop::classname(), [
                'type'=>DepDrop::TYPE_SELECT2,
                'data' => $estandar,
                'options'=>['id'=>'estandar-id',],
                'select2Options'=>[
                    'addon' => ['append' => ['content' => Html::button('<i id="showCreateEstandar" class="fa fa-plus" aria-hidden="true"></i>', ['value' => Url::to(['estandar/add']), 'id' => 'addbutton', 'title' => Yii::t('app', 'Agregar Estandar'), 'class' => 'showModalButton btn btn-primary', 'disabled' => false]), 'asButton' => true,]],
                ],
                'pluginOptions'=>[
                    'placeholder'=>'Seleccione el Estandar',
                    'depends'=>['grado-id','asignatura-id','periodo-id'],
                    'url'=>Url::to(['publica/findestandares']),
                ]
            ]);
            ?>
        </div>
        

        <div class="col-sm-12">
            <?= $form->field($model, 'competencia')->textarea(['rows' => 3]) ?>
        </div>  
    
    <?php ActiveForm::end(); ?>
    </div>
</div>



<? if(!$model->isNewRecord) { ?>


<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Niveles de Desempeño y FRD</h3>
    </div>

    <div class="panel-body">
        <div class="col-sm-12">
            <?= $this->render('_dataNivel', ['model' => $model]); ?>
        </div>  
    </div>
</div>

<? } ?>



