<div class="form-group" id="add-nivel">
<?php
use kartik\grid\GridView;
use kartik\builder\TabularForm;
use yii\data\ArrayDataProvider;
use yii\helpers\Html;
use yii\widgets\Pjax;
use yii\helpers\ArrayHelper;

use backend\models\Grado;
use backend\models\Desempeno;
use backend\models\Asignatura;
use backend\models\Periodo;

// \Yii::$app->user->can('update'),

if (isset($grado) and $grado != '')
{
    $tipo = Grado::findOne($grado)->tipo_calificacion; 
    $query_desempeno = Desempeno::find()->where(['tipo_calificacion' => $tipo])->orderBy('desempeno')->asArray()->all();   
}
else
{
    $query_desempeno = Desempeno::find()->orderBy('desempeno')->asArray()->all();      
}


$dataProvider = new ArrayDataProvider([
    'allModels' => $row,
    'pagination' => [
        'pageSize' => -1
    ]
]);

echo TabularForm::widget([
    'dataProvider' => $dataProvider,
    'formName' => 'Nivel',
    'checkboxColumn' => false,
    'actionColumn' => false,
    'attributeDefaults' => [
        'type' => TabularForm::INPUT_TEXT,
    ],
    'attributes' => [
        //"id" => ['type' => TabularForm::INPUT_HIDDEN, 'columnOptions' => ['hidden'=>true]],
        "id" => ['type' => TabularForm::INPUT_TEXT, 'columnOptions' => []],
        'desempeno' => [
            'label' => 'Desempeño',
            'type' => TabularForm::INPUT_WIDGET,
            'widgetClass' => \kartik\widgets\Select2::className(),
            'options' => [
                'data' => ArrayHelper::map($query_desempeno, 'id', 'desempeno'),
                'options' => [
                    'placeholder' => Yii::t('app', 'Seleccione...'),
                ],                
            ],
            'pluginOptions' => [
                'allowClear' => true,
                'onClick' => 'agregarNivel()',
            ],
            'columnOptions' => ['width' => '200px']
        ],
        'nivel' => ['type' => TabularForm::INPUT_TEXT],
        'recomendacion' => [
            'label' => 'Recomendación',
            'type' => TabularForm::INPUT_TEXT
        ],
        //'estado' => ['type' => TabularForm::INPUT_TEXT],
        'del' => [
            'type' => 'raw',
            'label' => '',
            'value' => function($model, $key) {
                return
                    Html::hiddenInput('Children[' . $key . '][id]', (!empty($model['id'])) ? $model['id'] : "") .
                    Html::a('<i class="glyphicon glyphicon-trash"></i>', '#', ['title' =>  Yii::t('app', 'Delete'), 'onClick' => 'delRowNivel(' . $key . '); return false;', 'id' => 'nivel-del-btn']);
            },
        ],
    ],
    'gridSettings' => [
        'panel' => [
            'heading' => false,
            'type' => GridView::TYPE_DEFAULT,
            'before' => false,
            'footer' => false,
            'after' => Html::button('<i class="glyphicon glyphicon-plus"></i>' . Yii::t('app', 'Agregar Nivel'), ['type' => 'button', 'id' => 'nivelbutton', 'class' => 'btn btn-success kv-batch-create','disabled' => 'disabled' ,'onClick' => 'addRowNivel()']),
        ]
    ]
]);
echo  "    </div>\n\n";
?>

