<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;
use backend\models\Nivel;
use backend\models\Frd;

/* @var $this yii\web\View */
/* @var $model backend\models\Competencia */

$this->title = Yii::t('app', 'Competencia');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Competencia'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Actualizar', 'url' => 'update', 'id' => $model->id, 'icon' => '<i class="far fa-pencil"></i>', 'class' => 'primary'];
$this->params['actions'][] = ['label' => 'Nuevo', 'url' => 'create', 'icon' => '<i class="far fa-plus"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Listar', 'url' => 'index', 'icon' => '<i class="far fa-bars"></i>', 'class' => 'purple'];
$this->params['actions'][] = ['label' => 'PDF', 'url' => 'pdf', 'id' => $model->id, 'icon' => '<i class="far fa-file-pdf"></i>', 'class' => 'danger'];
$this->params['actions'][] = ['label' => 'Eliminar', 'url' => 'delete', 'id' => $model->id, 'icon' => '<i class="far fa-trash-alt"></i>', 'class' => 'danger'];


?>
<div class="competencia-view">

    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        
        
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> <?= Yii::t('app', 'Información de Competencia.') ?></h3>
            </div>
            <div class="panel-body">
                
                    <?php 
                        $gridColumn = [
                            ['attribute' => 'id', 'visible' => false],
                            [
                                'attribute' => 'competencia',
                                'label' => Yii::t('app', 'Competencia'),
                            ],
                            [
                                'attribute' => 'grados.grado',
                                'label' => Yii::t('app', 'Grado'),
                            ],
                            [
                                'attribute' => 'asignaturas.asignatura',
                                'label' => Yii::t('app', 'Asignatura'),
                            ],
                            [
                                'attribute' => 'periodos.periodo',
                                'label' => Yii::t('app', 'Periodo'),
                            ],
                            [
                                'attribute' => 'estandares.estandar',
                                'label' => Yii::t('app', 'Estandar'),
                            ],
                        ];
                        echo DetailView::widget([
                            'model' => $model,
                            'attributes' => $gridColumn
                        ]);
                    ?>
                
            </div>
        </div>
    </div>
    
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        
        
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title text-primary"><i class="fas fa-angle-double-right"></i> Información de Niveles de Desempeño y FRD.</h3>
            </div>
            <div class="panel-body">

                <table class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th scope="col"><?= Yii::t('app', 'Niveles'); ?></th>
                            <th scope="col"><?= Yii::t('app', 'Fortalezas, Recomendaciones y Debilidades'); ?></th>
                        </tr>
                    </thead>
                    <tbody>


<?php

    $niveles = Nivel::find()->Where(['competencia' => $model->id])->andWhere(['estado' => '1'])->orderBy(['desempeno' => SORT_DESC])->all();  


    foreach ($niveles as $nivel) { ?>

        <tr>
            <td style="vertical-align: top !important;">
                <a class="list-group-item list-group-item-action" id="nivel-<?= $nivel->id ?>" data-toggle="list" href="#list-<?= $nivel->id ?>" role="tab" aria-controls="list-<?= $nivel->id ?>">
                    <?= '<span class="badge badge-pill" style="color:#fff; background-color:'.$nivel->desempenos->color.';">'.$nivel->desempenos->desempeno.'</span>'; ?>
                    <?= $nivel->nivel ?>
                    
                </a>
            </td>
            <td>
        <?

            $frds = Frd::find()->Where(['nivel' => $nivel->id])->andWhere(['competencia' => $model->id])->andWhere(['nivel' => $nivel->id])->andWhere(['estado' => '1'])->orderBy(['frd_tipo' => SORT_ASC])->all();  

            echo '<ul id="list-frd" class="list-group">';

            if(count($frds) == 0)
            {
                echo '<li id="no-item" class="list-group-item d-flex justify-content-between align-items-center">'.Yii::t('app', 'No hay registros de fortalezas, recomendaciones y debilidades almacenados.').'</li>';
            }
            else
            {
                foreach ($frds as $frd) 
                {        
                    if ($frd->frd_tipo==1) $color="success";
                    if ($frd->frd_tipo==2) $color="info";
                    if ($frd->frd_tipo==3) $color="danger"; 
                    if ($frd->frd_tipo==4) $color="warning";
                     
                    echo '<li id="frd-'.$frd->id.'" class="list-group-item d-flex justify-content-between align-items-center">';
                    echo '<span class="badge badge-'.$color.' badge-pill">'.$frd->tipos->tipo.'</span>';
                    echo $frd->descripcion;
                    echo '</li>';
                
                }
            }
            echo "</ul></td>";
            echo "</tr>";
    }
?>
            </tbody>
        </table>
        
        </div>
    </div>
       

</div> 