<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use kartik\grid\GridView;

/* @var $this yii\web\View */
/* @var $model backend\models\Calificacion */

$this->title = $model->calificacion;
$this->params['breadcrumbs'][] = ['label' => 'Calificacions', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="calificacion-view">

    <div class="row">
        <div class="col-sm-9">
            <h2><?= 'Calificacion'.' '. Html::encode($this->title) ?></h2>
        </div>
    </div>

    <div class="row">
<?php 
    $gridColumn = [
        ['attribute' => 'id', 'visible' => false],
        'calificacion',
        'coevaluacion',
        'autoevaluacion',
        'heteroevaluacion',
        [
                'attribute' => 'docente0.id',
                'label' => 'Docente'
            ],
        [
                'attribute' => 'estudiante0.id',
                'label' => 'Estudiante'
            ],
        [
                'attribute' => 'asignatura0.asignatura',
                'label' => 'Asignatura'
            ],
        [
                'attribute' => 'grupo0.grupo',
                'label' => 'Grupo'
            ],
        [
                'attribute' => 'periodo0.periodo',
                'label' => 'Periodo'
            ],
        'nivelacion',
        'indicador',
        'observacion',
        'creado_el',
        'creado_por',
        'actualizado_el',
        'actualizado_por',
        'estado',
    ];
    echo DetailView::widget([
        'model' => $model,
        'attributes' => $gridColumn
    ]); 
?>
    </div>
</div>
