<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\helpers\ArrayHelper;
use yii\widgets\ListView;
use yii\widgets\Pjax;
use kartik\widgets\ActiveForm;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Competencia;
use backend\models\Calificacion;
use backend\models\Desempeno;
use backend\models\Carga;

 
   
$this->title = Yii::t('app', 'Comportamiento');
$this->params['breadcrumbs'][] = ['label' => 'Panel del Docente', 'url' => ['docente/index']];
$this->params['breadcrumbs'][] = $this->title;

$this->params['actions'][] = ['label' => 'Guardar', 'url' => false, 'action' => 'guardar', 'icon' => '<i class="far fa-check"></i>', 'class' => 'success'];
$this->params['actions'][] = ['label' => 'Cancelar', 'url' => ['index'], 'icon' => '<i class="far fa-times"></i>', 'class' => 'danger'];

//echo "<br>calificacionxcompetencia: ".$calificacionxcompetencia;


$this->registerCss("
.table > thead > tr > td.salmon, 
.table > tbody > tr > td.salmon, 
.table > tfoot > tr > td.salmon, 
.table > thead > tr > th.salmon, 
.table > tbody > tr > th.salmon, 
.table > tfoot > tr > th.salmon, 
.table > thead > tr.salmon > td, 
.table > tbody > tr.salmon > td, 
.table > tfoot > tr.salmon > td, 
.table > thead > tr.salmon > th, 
.table > tbody > tr.salmon > th, 
.table > tfoot > tr.salmon > th {
    background-color: #D291BC;
}

.table-hover > tbody > tr > td.salmon:hover, 
.table-hover > tbody > tr > th.salmon:hover, 
.table-hover > tbody > tr.salmon:hover > td, 
.table-hover > tbody > tr:hover > .salmon, 
.table-hover > tbody > tr.salmon:hover > th 
{
    background-color: #C789B2;
}
.btn-salmon{
    color: #fff;
    background-color: #8D6B82;
    border-color: #87667C;
}



.table > thead > tr > td.purple, 
.table > tbody > tr > td.purple, 
.table > tfoot > tr > td.purple, 
.table > thead > tr > th.purple, 
.table > tbody > tr > th.purple, 
.table > tfoot > tr > th.purple, 
.table > thead > tr.purple > td, 
.table > tbody > tr.purple > td, 
.table > tfoot > tr.purple > td, 
.table > thead > tr.purple > th, 
.table > tbody > tr.purple > th, 
.table > tfoot > tr.purple > th {
    background-color: #E8C2ED;
}

.table-hover > tbody > tr > td.purple:hover, 
.table-hover > tbody > tr > th.purple:hover, 
.table-hover > tbody > tr.purple:hover > td, 
.table-hover > tbody > tr:hover > .purple, 
.table-hover > tbody > tr.purple:hover > th 
{
    background-color: #E0BBE4;
}
.btn-purple{
    color: #fff;
    background-color: #92278F;
    border-color: #81227E;
}

");



$this->registerJs("

    $('.crear-usuario').click(function(){
    
            $('#'+this.id).remove();
            $('#user-'+this.id).html('".Html::img('@web/images/loading-plugin.gif')."');    
            
        $.ajax({
            type: 'POST',
            url: '". Url::to(['add-usuario'])."',
            data: {id : this.id},
            success: function (data) {
                

                $('#user-'+data).html('<span class=\"glyphicon glyphicon-lock text-success\" aria-hidden=\"true\"></span>');  
                
                swal({
                    title: 'En Horabuena!',
                    text: 'Se ha configurado para ingresar al sistema el usuario y contraseña '+data,
                    type: 'success'
                }); 
                
            }
        });
            
    });

");



?>

<script type="text/javascript">         

<?php if ($tipo_calificacion != 1){ ?>


    function promediar(id,tipo) 
    { 
        var i;
        var promedio;
        var suma_saber = 0;
        var suma_ser = 0;
        var suma_psi = 0;
        var promedio_saber = 0;
        var promedio_ser = 0;
        var promedio_psi = 0;

        for (i = 1; i <= <?= $num_comportamientos ?>; i++) {
            suma_saber = suma_saber + Number(document.getElementById("comportamiento-" + id + "-calificacion-" + i).value);
            console.log('Calificacion id: ' + id + ' i: ' + i); 
        }

        promedio = Number(((suma_saber / <?= $num_comportamientos ?> ) * 100) / 100); 
        
        $.ajax({
                url: '../desempeno/desempenocolor?calificacion=' + promedio +'&tipo_calificacion=' + tipo,
                success: function(color) {

                    $('#'+id).css('background-color', color);
                    console.log(color);
                },
                error: function() {
                    console.log("No se ha podido obtener la información de la fila" + id-1);
                }
            });
        
        $('#'+id).text(promedio.toFixed(1));



        if (e.keyCode == 13) {
           /* FOCUS ELEMENT */
           var inputs = $(this).parents('form').eq(0).find(':input');
           var idx = inputs.index(this);

           if (idx == inputs.length - 1) {
               inputs[0].select()
           } else {
               inputs[idx + 1].focus(); //  handles submit buttons
               inputs[idx + 1].select();
           }
           return false;
       }
        //console.log(promedio.toFixed(2)); 
    }

<?php } ?>

    function aplicaratodos(id,tipo,total,tipo_calificacion)
      {   //declaras una variable y un array
         var i,ArrayText = new Array();
         // obtienes el valor del elemento vr1 
         text1 = document.getElementById('op-'+tipo+'-'+id).value;
         
         // actualizas cada text
         for(i=0; i<total; i++)
         {
            if(tipo == 'definitiva')
            {
                ArrayText[i] = document.getElementById('comportamiento-'+ i +'-'+ tipo);    
            }
            else
            {
                ArrayText[i] = document.getElementById('comportamiento-'+ i +'-'+ tipo +'-'+id);
            }

            ArrayText[i].value=text1.toUpperCase();
            
            <?php if ($tipo_calificacion != 1){ ?>
                promediar(i,tipo_calificacion);
            <?php } ?>    
         }
      }


    function mayusculas(e) 
    {
        i = document.getElementById(e).value
        nota = i.toUpperCase();     
        document.getElementById(e).value = nota;

        $.ajax({
                url: '../obsgeneral/find?id=' + i,
                success: function(color) {

                    $('#'+id).css('background-color', color);
                    console.log(color);
                },
                error: function() {
                    console.log("No se ha podido obtener la información");
                }
            });
        
        $('#'+id).text(promedio.toFixed(1));
        //console.log(promedio.toFixed(2)); 
        
    }


    function validarObservaciones(e) 
    {
        i = document.getElementById(e).value
        datos = i.replace(/[^0-9,]/g, '');

        document.getElementById(e).value = datos;

    } 


    function AddObservaciones(id, observacion) 
    {

    
        $('#comportamiento-' + id + '-observacion_general').val( function( index, val ) {
            
            if(val == '')
            {
                return val + observacion;
            }
            else
            {
                return val + ',' + observacion;
            }
            
        });
        
        $('#add_'+observacion).html('<button type="button" id="add" class="btn btn-danger btn-xs" title="Eliminar" onclick="RemoveObservaciones('+ id +','+ observacion +');"><i class="fa fa-trash-alt" aria-hidden="true"></i></button>');


    }


    function RemoveObservaciones(id, observacion) 
    {

    
        $('#comportamiento-' + id + '-observacion_general').val( function( index, val ) {
            
            return val.replace(',' + observacion, '');
        });
        
        $('#add_'+observacion).html('<button type="button" id="add" class="btn btn-primary btn-xs" title="Agregar" onclick="AddObservaciones('+ id +','+ observacion +');"><i class="fa fa-plus" aria-hidden="true"></i></button>');

    }
    
    $('input[name=ids]').val(function(index, value) {
       return value.replace('54,', '');
    });
</script>
    

<div class="row">
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <div class="demo-btn-group">
            <div class="callout callout-success">
                <div class="row"> 
                    <div class="col-sm-12">
                        <h4>
                            <?
                                echo $grupo->directores->nombre;
                            ?>
                        </h4>
                    </div>
                </div>
                <div class="row"> 
                <div class="col-sm-4">
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-chalkboard-teacher fa-lg text-warning"></i>
                            <i class="fa-solid fa-person-circle-check text-warning"></i>
                            <?= strtoupper(Yii::t('app', 'Comportamiento del Estudiante')) ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-users fa-lg text-primary"></i>
                            <? 
                                echo "Grupo "; 
                                echo $grupo->grupo;
                            ?>
                        </h5>
                    </div>
                    <div class="col-sm-2">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-clock fa-lg text-danger"></i>
                            <?= "Periodo ".$periodo->actual->id; ?>
                        </h5>
                    </div>
                    <div class="col-sm-4">    
                        <h5 style="margin-top: 10px;">
                            <i class="far fa-pencil fa-lg text-success"></i>
                            <?= ($grupo->grados->calificacionxcompetencia == 1) ? '<span class="label label-primary">'.Yii::t('app', 'Calificación por Asignatura').'</span>' : '<span class="label label-success">'.Yii::t('app', 'Calificación por Competencia').'</span>'; ?>    
                            &nbsp; 
                            <?= '<span class="label label-warning">Tipo de Calificación '.$grupo->grados->tipoCalificaciones->tipo.'</span>'; ?>
                        </h5>
                    </div>
                </div>    
            </div>
        </div>
    </div>
</div>
<br>
<?php 
    
    if ($ver_nota == 1)
    {    
        
        if($num_comportamientos == 0 or $num_comportamientos == NULL or $num_comportamientos == '')
        {
?>

            <div class="row"> 
                <div class="col-sm-12"> 

                    <div class="alert alert-danger alert-dismissable">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <?  
                            echo Yii::t('app', '<b>No hay opciones de comportamiento cargadas en el sistema</b>, debes cargarlas primero para poder realizar el cargue de las calificaciones.');
                            echo Html::a('<i class="far fa-plus" aria-hidden="true"></i> '.Yii::t('app', 'Agregar Competencias'), ['competencia/create', 'grado' => $grupo->grados->id, 'asignatura' => Yii::$app->request->get('asignatura')],['class' => 'btn btn-xs btn-primary']);
                        ?>
                    </div>
                </div>
            </div>
<?php
        }
        else
        {    
            
            $x=1; 
       
?>        
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="alert alert-info alert-dismissable">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <?  
                            echo '<b>'.Yii::t('app', 'Comportamiento').'</b><br><ul>';

                            foreach ($competencias as $competencia) {
                                echo '<li><i class="fas fa-caret-right"></i>&nbsp;&nbsp;'.$competencia->comportamiento.'</li>';
                            }

                        ?>
                        </ul>
                    </div>        
                </div>
            </div>

<?
            
        }    
    }
?>    


  
    <? 
    $form = ActiveForm::begin([
            'validateOnSubmit' => true,
            'type' => ActiveForm::TYPE_VERTICAL,
            'options' => ['class' => 'main-task-form',
                          'id' => 'formulario',
                        ]
        ]);
    ?>  

<?php if ($ver_nota == 1) { ?>

    <div class="row"> 
        <div class="col-sm-12"> 

            <div class="alert alert-info alert-dismissable">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                <?  
                    echo '<b>'.Yii::t('app', 'Niveles de Desempeño').'</b> ';

                    $desempenos = Desempeno::find()->where(['tipo_calificacion' => $grupo->grados->tipo_calificacion])->all();
                    foreach ($desempenos as $desempeno) {
                        $rango = ($desempeno->limite_inferior != '') ? ' ('.$desempeno->limite_inferior : '';
                        $rango .= ($desempeno->limite_superior != '') ? ' a '.$desempeno->limite_superior.')' : '';    
                        echo '<span class="label" data-toggle="tooltip" title="'.$desempeno->desempeno.''.$rango.'" style="width:50px; background-color:'.$desempeno->color.'; color:#fff; margin:0 2px 0 10px;">'.$desempeno->nota.'</span> <b>'.$desempeno->desempeno.'</b><small> '.$rango.'</small>';
                    }
                ?>
            </div>
        </div>
    </div>

<?php } ?>

    <div class="row"> 
        <div class="col-sm-12">     
            <?= $form->errorSummary($comportamientos); ?>
        </div>
    </div>

<?php if($dataProvider->getTotalCount()!= 0) { ?>

    <div class="row"> 
        <div class="col-sm-12">     
            <div class="table-responsive">    
              <table class="table table-hover table-striped">
                <thead>

                    
                  <tr>
                    <th rowspan="2" style="width:10px;"></th>
                    <th rowspan="2" style="width:300px;"><?= Yii::t('app', 'Estudiante') ?></th>
                    
                       
                    <?php 

                        if($ver_nota == 1)
                        {
                            $sum = $num_comportamientos + 3;

                            ////  NOTAS DE LAS COMPETENCIAS
                            $x = 1; 
                            foreach ($competencias as $competencia) {
                            
                                echo '<th colspan="1" style="max-width:100px;">';
                                    
                                echo Html::tag('span','<i class="fas fa-info-circle"></i> '.Yii::t('app', 'Nota').' '.$x, ['class' => 'btn btn-block btn-info', 'data-toggle' => 'tooltip', 'title' => $competencia->comportamiento]);

                                echo '</th>';
                                $x++;
                            }
                           
                            /////////////   PROMEDIO  ///////////////////////////

                            if($tipo_calificacion=='2')
                            {
                                echo '<th rowspan="2" style="max-width:30px !important; vertical-align: middle; text-align: center;">';
                                echo Html::tag('span', '<i class="fas fa-info-circle"></i>', ['title' => 'Promedio', 'data-toggle' => 'tooltip', 'class' => 'text-info']);
                                echo '</th>';
                            }
                        }

                    ?>  
                    
                    <?php if($observacion_general == 1) { ?>
                        <th>
                            <? Html::tag('span','<i class="fas fa-info-circle"></i> '.Yii::t('app', 'Observaciones'), ['class' => 'btn btn-block btn-warning', 'data-toggle' => 'tooltip', 'title' => Yii::t('app', 'Observaciones Generales y Específicas')]); ?>
                            <?= Html::button('<i class="fas fa-info-circle"></i> '.Yii::t('app', 'Observaciones'), ['value' => Url::to(['obsgeneral/listar','id' => '0']), 'title' => Yii::t('app', 'Observaciones Generales'), 'class' => 'showModalButton btn btn-block btn-warning']);  ?>
                        </th> 
                    <?php } ?>
                    
                    <?php if($observacion_especifica == 1) { ?>
                        <th>
                            <? Html::tag('span','<i class="fas fa-info-circle"></i> '.Yii::t('app', 'Observaciones'), ['class' => 'btn btn-block btn-warning', 'data-toggle' => 'tooltip', 'title' => Yii::t('app', 'Observaciones Generales y Específicas')]); ?>
                            <?= Html::button('<i class="fas fa-info-circle"></i> '.Yii::t('app', 'Observaciones'), ['value' => Url::to(['obsgeneral/listar','id' => '0']), 'title' => Yii::t('app', 'Observaciones Generales'), 'class' => 'showModalButton btn btn-block btn-warning']);  ?>
                        </th> 
                    <?php } ?>

                    <?php if($tipo_calificacion=='1') { ?>
                        <th>
                            <?= Html::tag('span','<i class="fas fa-info-circle"></i> '.Yii::t('app', 'Definitiva'), ['class' => 'btn btn-block btn-danger', 'data-toggle' => 'tooltip', 'title' => Yii::t('app', 'Calificación Definitiva del Comportamiento')]); ?>
                            
                        </th> 
                    <?php } ?>

                    </tr>

                    <!--  //////////////////  SEGUNDA FILA DE LAS OPCIONES   ///////////////////    -->
                    <tr>
                    
                    <?php 
                        if($ver_nota == 1)
                        {    
                            $i = 1;
                            foreach ($competencias as $competencia) 
                            { 
                                echo "<th style='max-width:80px'>";
                                echo $this->render('_seleccionmultiple', ['model' => $seleccionmultiple, 'i' => $i, 'num_calificaciones' => $num_comportamientos, 'tipo' => 'calificacion', 'total_estudiantes' => $dataProvider->getTotalCount(), 'tipo_calificacion' => $tipo_calificacion, 'calificacionxcompetencia' => $calificacionxcompetencia]);
                                echo "</th>"; 
                                $i++; 
                            }
                        } 
                    ?> 
                    
                    <?php if($observacion_general == 1) { ?>
                        <th style="width:<?= $entrada == '1' ? '120px;' : '120px;' ?> vertical-align: middle; text-align: center;">
                            General
                            <?= Html::a('<i class="fas fa-info-circle"></i>', false, ['value' => Url::to(['obsgeneral/listar']), 'title' => Yii::t('app', 'Observaciones Generales'), 'class' => 'showModalButton text-info']); ?>
                        </th>
                    <?php } ?>

                    <?php if($observacion_especifica == 1) { ?>
                        <th style="width:500px; vertical-align: middle; text-align: center;"><?= Yii::t('app', 'Específica') ?></th>
                    <?php } ?>

                    <?php if($tipo_calificacion=='1') { ?>
                        <th style='max-width:80px'>
                                <?= $this->render('_seleccionmultiple', ['model' => $seleccionmultiple, 'i' => $i, 'num_calificaciones' => $num_comportamientos, 'tipo' => 'definitiva', 'total_estudiantes' => $dataProvider->getTotalCount(), 'tipo_calificacion' => $tipo_calificacion, 'calificacionxcompetencia' => $calificacionxcompetencia]); ?>
                        </th>
                    <?php } ?>

                  </tr>
                </thead>
                <tbody>

<?php } ?>

            <?= ListView::widget([
                'dataProvider' => $dataProvider,
                'options' => [
                    'tag' => 'div',
                    'class' => 'list-wrapper',
                    'id' => 'list-wrapper',
                ],
                'viewParams' => ['comportamientos' => $comportamientos, 
                                    'registros' => $registros,
                                    'form' => $form, 
                                    'periodo' => $periodo->actual->id, 
                                    'competencias' => $competencias,
                                    'tipo_calificacion' => $tipo_calificacion,
                                    'calificacionxcompetencia' => $calificacionxcompetencia,
                                    'entrada' => $entrada,
                                    'num_comportamientos' => $num_comportamientos,
                                    'ver_nota' => $ver_nota,
                                    'observacion_general' => $observacion_general,
                                    'observacion_especifica' => $observacion_especifica,
                                ],
                'itemView' => '_list_calificaciones',
                'layout' => "{pager}\n{items}\n{summary}",
                'summary'=>'', 
            ]);
                
            ?>

<?php if($dataProvider->getTotalCount()!= 0) { ?>

                </tbody>
              </table> 
            
    </div>

<?php } ?>
<? ActiveForm::end(); ?>



